# -*- coding: utf-8 -*-
'''
Created on Nov 14, 2012

@author: ymh
'''

from . import settings
from .models import VideoKCRel
from .utils import get_all_objects
from django import forms
import logging

logger = logging.getLogger(__name__)

class VideoKCRelForm(forms.ModelForm):
    
    iri_id = forms.CharField(max_length=255, widget=forms.widgets.Select())
    project_id =  forms.CharField(max_length=255, widget=forms.widgets.Select())

    def __init__(self, *args, **kwargs):
        super(VideoKCRelForm, self).__init__(*args, **kwargs)
        
        url = settings.LDT_API_URL + "contents/"
        contents = get_all_objects(url, {'limit':settings.LDT_MAX_FETCH}, 'front_project')
        self.fields['iri_id'].widget.choices = [(content['iri_id'], content['title']) for content in contents]
        
        url = settings.LDT_API_URL + "projects/"
        projects = get_all_objects(url, {'state': 2, 'limit': settings.LDT_MAX_FETCH}, None)
        logger.debug("projects " + repr(projects))
        values = [(None, "-----")]
        values.extend([(project['ldt_id'], project['title']) for project in projects])
        
        self.fields['project_id'].widget.choices = values


    class Meta:
        model = VideoKCRel
    