# -*- coding: utf-8 -*-
'''
Created on Nov 11, 2012

@author: ymh
'''
from django.shortcuts import render_to_response
from django.template.context import RequestContext
import requests
from django.conf import settings
import logging
import urlparse

logger = logging.getLogger(__name__)


def all_videos(request):
    
    #get all videos
    #render
    url = settings.LDT_API_URL + "contents/"
    #limit=20&offset=20
    r = requests.get(url)
        
    
    
    results = r.json
        
    for content in results.get('objects', []):
        url_parts = urlparse.urlparse(content.get('image',''))
        if not url_parts.netloc:
            content['image'] = settings.LDT_DOMAIN + content.get('image','')
        
    return render_to_response('hp/all_videos.html',{'results':results}, context_instance=RequestContext(request))
    

def show_video_details(request, content_id):
    
    url_content = settings.LDT_API_URL + "contents/%s" % content_id
    
    r_content = requests.get(url_content)
        
    logger.debug(r_content.text)

    return render_to_response('hp/video_player.html',{'content':r_content.json}, context_instance=RequestContext(request))