<?php
/*
 * This file is part of the WikiTagBundle package.
 *
 * (c) IRI <http://www.iri.centrepompidou.fr/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace Company\BaseBundle\Event;

use Symfony\Component\DependencyInjection\ContainerInterface;
use IRI\Bundle\WikiTagBundle\Event\DocumentTagEvent;

class TestListener
{
    /**
    * @var ContainerInterface
    */
    private $container;
    
    
    public function getContainer()
    {
        return $this->container;
    }
    
    /**
     * Constructor
     *
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;
    }
        
    public function onTagCreateAction(DocumentTagEvent $event)
    {
        $this->getContainer()->get('logger')->debug("updating tags for doc ".strval($event->getDocument()->getId()));
    }
}