<?php
/*
 * This file is part of the WikiTagBundle package.
 *
 * (c) IRI <http://www.iri.centrepompidou.fr/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace Company\BaseBundle\DataFixures\ORM;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Doctrine\Common\DataFixtures\FixtureInterface;
use Company\BaseBundle\Entity\Document;

class LoadDocumentData implements FixtureInterface, ContainerAwareInterface
{
    private $container;

    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }
    
    public function load($manager) {
        
        # create new document
        
        $doc_def_list = array(
            array('title'=>'Title 1', 'description'=>'Description 1', 'tags' => array('tag1', 'tag2', 'tag3', 'tag4')),
            array('title'=>'Title 2', 'description'=>'Description 2', 'tags' => array('tag2', 'tag3', 'tag4')),
            array('title'=>'Title 3', 'description'=>'Description 3', 'tags' => array('tag3', 'tag4')),
            array('title'=>'Title 4', 'description'=>'Description 4', 'tags' => array()),
        );
        
        foreach ($doc_def_list as $doc_def) {
            
            $newdoc = new Document();
            $newdoc->setTitle($doc_def['title']);
            $newdoc->setDescription($doc_def['description']);
                       
            $manager->persist($newdoc);
            
            $manager->flush();
            
            $this->container->get('wiki_tag.document')->addTags($newdoc->getId(), $doc_def['tags']);
        }
        
        # add tags
        
        $manager->flush();
        
    }
 
}