<?php

namespace Application\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration,
    Doctrine\DBAL\Schema\Schema,
	IRI\Bundle\WikiTagBundle\Utils\WikiTagUtils;

/**
 * Migration for WikiTagBundle <= V00.13
 * This migration takes every tag label and search the REAL dbpedia uri associated to this label.
 * Before, the dbpedia uri was manually generated by http://dbpedia.org/resource/ + english_label.
 * Now we get the dbpedia uri by requesting http://LANG_CODE.dbpedia.org/sparql with the current label.
 * 
 */
class Version20140129151724 extends AbstractMigration
{
    public function up(Schema $schema)
    {
        // this up() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != "mysql");
        
        // First we get all tags.
        $em = $GLOBALS["kernel"]->getContainer()->get( 'doctrine.orm.entity_manager' );
        $query = $em->createQuery('SELECT t FROM WikiTagBundle:Tag t ORDER BY t.label ASC');//->setMaxResults(40)->setFirstResult(5000);
        $tags = $query->getResult();
        
        $i = 1;
        foreach($tags as $tag){
        	$l = $tag->getLabel();
        	$uri = WikiTagUtils::getDbpediaUri($tag->getLabel(), [], false);
        	$tag->setDbpediaUri($uri);
        	$em->persist($tag);
        	if( $i % 50 == 0 ){
        		$em->flush();
        		echo "\n    FLUSH";
        	}
        	$i++;
        	echo "\n$i : $l \t\t: $uri";
        }
        $em->flush();
    }

    public function down(Schema $schema)
    {
        // this down() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != "mysql");
    }
}
