<?php

namespace Company\BaseBundle\Controller;

use Company\BaseBundle\Entity\Document;
use IRI\Bundle\WikiTagBundle\Entity\Document as BaseDocument;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;


class IndexController extends Controller
{
    
    public function indexAction()
    {
        return $this->render('CompanyBaseBundle:Index:index.html.twig');
    }
    
    public function otherAction()
    {
        return $this->render('CompanyBaseBundle:Index:other_page.html.twig');
    }
    
    
    public function addDocumentAction(Request $request)
    {
        $doc = new Document();
        
        $form = $this->createFormBuilder($doc)
        ->add('title', 'text')
        ->add('description', 'textarea', array("required" => false,))
        ->getForm();
    
        if ($request->getMethod() == 'POST') {
            $form->bindRequest($request);
            if ($form->isValid()) {
                $doc = $form->getData();
                $em = $this->getDoctrine()->getEntityManager();
                $em->persist($doc);
                $em->flush();
                return $this->redirect($this->generateUrl('all_documents'));
            }
        }
        else{
            return $this->render('CompanyBaseBundle:Index:add_document.html.twig', array('form' => $form->createView()));
        }
    }
    
    
    public function allDocumentsAction()
    {
        $rep_docs = $this->getDoctrine()->getRepository('CompanyBaseBundle:Document');
	    $documents = $rep_docs->findAll();
	    
        return $this->render('CompanyBaseBundle:Index:all_documents.html.twig', array('documents' => $documents));
    }
    
    
    public function allDocumentsPartialAction($param="")
    {
        $rep_docs = $this->getDoctrine()->getRepository('CompanyBaseBundle:Document');
	    $documents = $rep_docs->findAll();
	    
        return $this->render('CompanyBaseBundle:Index:all_documents_partial.html.twig', array('documents' => $documents, 'param' => $param));
    }
    
    /**
     * Template with tag management
     *
     */
    public function documentWithTagAction($idDoc)
    {
        $rep_docs = $this->getDoctrine()->getRepository('CompanyBaseBundle:Document');
    	$doc = $rep_docs->findOneById($idDoc);
        return $this->render('CompanyBaseBundle:Index:tag_embedder.html.twig', array('doc' => $doc));
    }
    
}
