<?php

namespace Application\Migrations;

use Doctrine\DBAL\Migrations\OutputWriter;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;
use Doctrine\Common\EventManager;
use Doctrine\ORM\EntityManager;
use IRI\Bundle\WikiTagBundle\Utils\WikiTagUtils;
use IRI\Bundle\WikiTagBundle\Entity\Tag;


/**
 * Auto-generated Migration: Please modify to your need!
 */
class Version20111125175224 extends AbstractMigration
{
    
    private function showProgress($current, $total, $label, $width)
    {
        $percent = (floatval($current)/floatval($total)) * 100.0;
        $marks = intval(floor(floatval($width) * ($percent / 100.0) ));
        $spaces = $width - $marks;
    
        $status_bar="\r[";
        $status_bar.=str_repeat("=", $marks);
        if($marks<$width){
            $status_bar.=">";
            $status_bar.=str_repeat(" ", $spaces);
        } else {
            $status_bar.="=";
        }
    
        $disp=str_pad(number_format($percent, 0),3, " ", STR_PAD_LEFT);
    
        $label = str_pad(substr($label,0,50), 50, " ");
        $current_str = str_pad($current, strlen("$total"), " ", STR_PAD_LEFT);
    
        $status_bar.="] $disp%  $current_str/$total : $label";
    
        $this->write("$status_bar  ");
    
        if($current == $total) {
            $this->write("\n");
        }
    }
    
    public function up(Schema $schema)
    {
        // this up() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != "mysql");
        
        $this->addSql("ALTER TABLE wikitag_document ADD CONSTRAINT FK_256601059F75D7B0 FOREIGN KEY (external_id) REFERENCES Document(id)");
        $this->addSql("ALTER TABLE wikitag_document_tag CHANGE wikipedia_revision_id wikipedia_revision_id BIGINT DEFAULT NULL");
        $this->addSql("ALTER TABLE wikitag_tag ADD alternative_label VARCHAR(1024) DEFAULT NULL, ADD wikipedia_alternative_url VARCHAR(2048) DEFAULT NULL, ADD alternative_wikipedia_pageid BIGINT DEFAULT NULL, CHANGE normalized_pageid wikipedia_pageid BIGINT DEFAULT NULL");
    }
    
    public function postUp(Schema $schema)
    {
        $doctrine = $GLOBALS["application"]->getKernel()->getContainer()->get('doctrine');
        $em = $doctrine->getEntityManager();
        
        $this->skipIf($this->version->isMigrated() !== true, 'postUp can only apply if migration completes.');
    
        //select all tags with redirect and alternative label null
        $query = $em->createQuery("SELECT t FROM WikiTagBundle:Tag t WHERE t.urlStatus = :url_status AND t.alternativeLabel IS NULL");
        $query->setParameter("url_status", Tag::$TAG_URL_STATUS_DICT['redirection']);

        $querycount = $em->createQuery("SELECT count(t) FROM WikiTagBundle:Tag t WHERE t.urlStatus = :url_status AND t.alternativeLabel IS NULL");
        $querycount->setParameter("url_status", Tag::$TAG_URL_STATUS_DICT['redirection']);
        
        
        $total = $querycount->getSingleScalarResult();
        $iterableResult = $query->iterate();
        $i = 0;
        $em->beginTransaction();
        foreach($iterableResult as $row) {
            $i++;
            $tag = $row[0];
    
            $memory = ((($i%10)==0)?" - mem: ".strval(memory_get_usage(true)):"");
            $this->showProgress($i, $total, "tag : ".$tag->getLabel()."$memory", 50);
            //process $tag
            $wk_info = WikiTagUtils::getWikipediaInfo($tag->getNormalizedLabel());
    
            $tag->setWikipediaInfo($wk_info);
            
            $em->persist($tag);
                            
            if (($i % 100) == 0) {
                $em->flush();
                $em->commit();
                $em->clear(); // Detaches all objects from Doctrine!
                $em->beginTransaction();
            }
        }
        
        $em->flush(); // Executes all updates.
        $em->commit();
        $em->clear(); // Detaches all objects from Doctrine!
    
    }
    
    public function down(Schema $schema)
    {
        // this down() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != "mysql");
        
        $this->addSql("ALTER TABLE wikitag_document DROP FOREIGN KEY FK_256601059F75D7B0");
        $this->addSql("ALTER TABLE wikitag_document_tag CHANGE wikipedia_revision_id wikipedia_revision_id BIGINT NOT NULL");
        $this->addSql("ALTER TABLE wikitag_tag DROP alternative_label, DROP wikipedia_alternative_url, DROP alternative_wikipedia_pageid, CHANGE wikipedia_pageid normalized_pageid BIGINT DEFAULT NULL");
    }
    
    
}
