<?php

namespace Application\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration,
    Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your need!
 */
class Version20111125175224 extends AbstractMigration
{
    public function up(Schema $schema)
    {
        // this up() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != "mysql");
        
        $this->addSql("ALTER TABLE wikitag_document ADD CONSTRAINT FK_256601059F75D7B0 FOREIGN KEY (external_id) REFERENCES Document(id)");
        $this->addSql("ALTER TABLE wikitag_document_tag CHANGE wikipedia_revision_id wikipedia_revision_id BIGINT DEFAULT NULL");
        $this->addSql("ALTER TABLE wikitag_tag ADD alternative_label VARCHAR(1024) DEFAULT NULL, ADD wikipedia_alternative_url VARCHAR(2048) DEFAULT NULL, ADD alternative_wikipedia_pageid BIGINT DEFAULT NULL, CHANGE normalized_pageid wikipedia_pageid BIGINT DEFAULT NULL");
    }
    
    public function postUp(Schema $schema)
    {
        $evm = new EventManager();
        $em = EntityManager::create($conn, $this->configuration, $evm);
    
        //select all tags with redirect and alternative label null
        $query = $em->createQuery("SELECT t FROM WikiTagBundle:Tag t WHERE t.urlStatus = :url_status AND t.alternativeLabel IS NULL");
        $query->setParameter("url_status", Tag::$TAG_URL_STATUS_DICT['redirection']);
    
        $iterableResult = $query->iterate();
        $i = 0;
    
        foreach($iterableResult AS $row) {
            $i++;
            $tag = $row[0];
    
            //process $tag
            $wk_info = WikiTagUtils::getWikipediaInfo($tag->getNormalizedLabel());
    
            $tag->setWikipediaInfo($wk_info);
    
            if (($i % 100) == 0) {
                $em->flush(); // Executes all updates.
                $em->clear(); // Detaches all objects from Doctrine!
            }
        }
    
    }
    
    public function down(Schema $schema)
    {
        // this down() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != "mysql");
        
        $this->addSql("ALTER TABLE wikitag_document DROP FOREIGN KEY FK_256601059F75D7B0");
        $this->addSql("ALTER TABLE wikitag_document_tag CHANGE wikipedia_revision_id wikipedia_revision_id BIGINT NOT NULL");
        $this->addSql("ALTER TABLE wikitag_tag ADD normalized_pageid BIGINT DEFAULT NULL, DROP alternative_label, DROP wikipedia_alternative_url, DROP alternative_wikipedia_pageid, CHANGE wikipedia_pageid normalized_pageid BIGINT DEFAULT NULL");
    }
    
    
}
