# -*- coding: utf-8 -*-
'''
Created on Jan 26, 2012

@author: ymh
'''
import logging
import os

from environs import Env
 
env = Env()
# Read .env into os.environ
env.read_env()

DEBUG = env.bool("DEBUG", default=False)
TEMPLATE_DEBUG = DEBUG

ADMINS = (
    ('Hdalab admin', env.str("ADMIN_EMAIL")),
)

MANAGERS = ADMINS

DATABASES = {
    'default': env.dj_db_url("DATABASE_URL"),
}

CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.memcached.MemcachedCache',
        'LOCATION': 'cache:11211',
        'KEY_PREFIX': 'hdalab2',
        'TIMEOUT': 500,
    }
}

BASE_DIR = "/code/"
BASE_URL = '/'
WEB_URL = 'https://hdalab.iri-research.org'
SCRIPT_PREFIX = BASE_URL + 'hdalab'

LOCALE_PATHS = ( os.path.join(BASE_DIR, 'locale',), )

# Absolute filesystem path to the directory that will hold user-uploaded files.
# Example: "/home/media/media.lawrence.com/media/"
MEDIA_ROOT = "/static/media/"

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash.
# Examples: "http://media.lawrence.com/media/", "http://example.com/media/"
MEDIA_URL = BASE_URL + "static/media/"

# Absolute path to the directory static files should be collected to.
# Don't put anything in this directory yourself; store your static files
# in apps' "static/" subdirectories and in STATICFILES_DIRS.
# Example: "/home/media/media.lawrence.com/static/"
STATIC_ROOT = "/static/site/"

# URL prefix for static files.
# Example: "http://media.lawrence.com/static/"
STATIC_URL = BASE_URL + "static/site/"

# URL prefix for admin static files -- CSS, JavaScript and images.
# Make sure to use a trailing slash.
# Examples: "http://foo.com/static/admin/", "/static/admin/".
ADMIN_MEDIA_PREFIX = STATIC_URL + 'admin/'

# Hosts/domain names that are valid for this site; required if DEBUG is False
# See https://docs.djangoproject.com/en/1.5/ref/settings/#allowed-hosts
ALLOWED_HOSTS = ['hdalab.iri-research.org']

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# In a Windows environment this must be set to your system time zone.
TIME_ZONE = 'Europe/Paris'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'fr-FR'

SITE_ID = 1

#if you set this to False, Django will not use timezone-aware datetimes.
USE_TZ = True

HAYSTACK_CONNECTIONS = {
    'default': {
        'ENGINE': 'haystack.backends.elasticsearch_backend.ElasticsearchSearchEngine',
        'URL': "http://"+env.str("ES_HOST", default="es")+":9200",
        'INDEX_NAME': 'jocondelab',
    },
}

# Make this unique, and don't share it with anybody.
SECRET_KEY = env.str("DJANGO_SECRET")

#LOG_FILE = os.path.abspath(os.path.join(BASE_DIR,"../../run/log/log.txt"))
LOG_LEVEL = logging.INFO

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'filters': {
        'require_debug_false': {
            '()': 'django.utils.log.RequireDebugFalse'
        }
    },
    'formatters' : {
        'simple' : {
            'format': "%(asctime)s - %(levelname)s : %(message)s",
        },
        'semi-verbose': {
            'format': '%(levelname)s %(asctime)s %(module)s %(message)s'
        },
    },
    'handlers': {
        'stream_to_console': {
            'level': LOG_LEVEL,
            'class': 'logging.StreamHandler'
        },
    },
    'loggers': {
        'django.request': {
            'handlers': ['stream_to_console'],
            'level': 'ERROR',
            'propagate': True,
        },
        'hdabo': {
            'handlers': ['stream_to_console'],
            'level': 'DEBUG',
            'propagate': True,
        },
        'hdalab': {
            'handlers': ['stream_to_console'],
            'level': 'DEBUG',
            'propagate': True,
        },
        'core': {
            'handlers': ['stream_to_console'],
            'level': 'DEBUG',
            'propagate': True,
        },
        'rdflib_sqlalchemy': {
            'handlers': ['stream_to_console'],
            'level': 'DEBUG',
            'propagate': True,
        },
    }
}


USE_ETAGS = False

GOOGLE_ANALYTICS_CODE = None

DEFAULT_FROM_EMAIL = "do-not-reply@iri-research.org"

ENVELOPE_EMAIL_RECIPIENTS= ['histoiredesarts@culture.gouv.fr']

RENKAN_PREVIEW_PHANTOMJS_PATH = '/usr/local/bin/phantomjs'

BROKER_URL = 'amqp://iri:'+ env.str('BROKER_PASSWORD') +'@broker:5672/hdalab'

RENKAN_TUTORIAL_VIDEO_URLS = [
    {'format': 'video/mp4', 'url': 'http://media.iri.centrepompidou.fr/video/hdalab/hdalab_renkan_presentation_720p.mp4' },
    {'format': 'video/webm', 'url': 'http://media.iri.centrepompidou.fr/video/hdalab/hdalab_renkan_presentation_720p.webm' },
    {'format': 'video/ogg', 'url': 'http://media.iri.centrepompidou.fr/video/hdalab/hdalab_renkan_presentation_720p.ogv' }
]

WIKIPEDIA_API_URL = "https://fr.wikipedia.org/w/api.php"


