# -*- coding: utf-8 -*-
'''
Created on Jan 27, 2012

@author: ymh
'''
from django.db import models
from hdabo.models import Tag


class TagYears(models.Model):
    
    tag = models.ForeignKey(Tag, related_name="years", blank=False, null=False, db_index=True)
    start_year = models.IntegerField(blank=False, null=False, db_index=True)
    end_year = models.IntegerField(blank=False, null=False, db_index=True)
    
    class Meta:
        app_label = 'hdalab'
        

class TagLinks(models.Model):
    
    subject = models.ForeignKey(Tag, blank=False, null=False, db_index=True, related_name="taglinks_subjects")
    object = models.ForeignKey(Tag, blank=False, null=False, db_index=True, related_name="taglinks_objects")
    
    class Meta:
        app_label = 'hdalab'

#class CountryCode(models.Model):
#
#    label = models.CharField(max_length=1024, unique=True, blank=False, null=False, db_index=True)
#    isocode = models.CharField(max_length=3, unique=True, blank=False, null=False, db_index=True)
#    
#    class Meta:
#        app_label = 'hdalab'

class Country(models.Model):
    
    dbpedia_uri = models.URLField(verify_exists=False, max_length=255, blank=False, null=False, db_index=True, unique=True)
    
    class Meta:
        app_label = 'hdalab'

class GeoInclusion(models.Model):
    
    tag = models.OneToOneField(Tag, related_name="locatedin", db_index=True)
    country = models.ForeignKey(Country, blank=False, null=False, related_name="includes", db_index=True)
    
    class Meta:
        app_label = 'hdalab'

class DbpediaFields(models.Model):

    dbpedia_uri = models.URLField(verify_exists=False, max_length=2048, blank=False, null=False, db_index=True, unique=False)
    tag = models.OneToOneField(Tag, blank=True, null=True, db_index=True, related_name="dbpedia_fields")
    abstract = models.TextField(blank=True, null=True)
    label = models.CharField(max_length=2048, unique=False, blank=True, null=True)
    thumbnail = models.URLField(verify_exists=False, max_length=2048, blank=True, null=True, db_index=False)

    class Meta:
        app_label = 'hdalab'

class HdaSession(models.Model):
    
    sessionid = models.CharField(max_length=36, unique=True, blank=False, null=False, db_index=True)
    data = models.TextField(blank=True, null=True)
    
    class Meta:
        app_label = 'hdalab'
        
