var selectedelement = null;

function drawlinks() {
    var w$ = $(window)
        scroll = w$.scrollTop(),
        windowheight = w$.height();
    $(".tags-main, .main-datasheet").css({
        "margin-top": Math.max(0, scroll - 60) + "px"
    });
    var cvheight = Math.max($(".tags-main").outerHeight(), $(".related-datasheets").outerHeight()),
        cvwidth = $(".tag-container").width(),
        cv$ = $(".tag-canvas"),
        cvo = cv$.offset(),
        colors = ["#1f77b4","#aec7e8","#ff7f0e","#ffbb78","#2ca02c","#98df8a","#d62728","#ff9896","#9467bd","#c5b0d5","#8c564b","#c49c94","#e377c2","#f7b6d2","#7f7f7f","#c7c7c7","#bcbd22","#dbdb8d","#17becf","#9edae5"];
    cv$.attr({
        width: cvwidth,
        height: cvheight
    }).css({
        width: cvwidth,
        height: cvheight
    });
    
    $(".main-datasheet-tag, .datasheet").css("opacity", selectedelement ? .7 : 1);
    $(selectedelement).css("opacity",1);
    
    var ctx = cv$[0].getContext('2d'),
        mds$ = $(".main-datasheet"),
        ymain = Math.floor(mds$.height() / 2 + mds$.offset().top - cvo.top);
    
    $(".main-datasheet-tag").each(function() {
        var tag$ = $(this),
            ytag = Math.floor(tag$.offset().top + tag$.outerHeight() / 2 - cvo.top);
        ctx.strokeStyle = "#999999";
        ctx.lineWidth = (this === selectedelement ? 4 : 1);
        ctx.beginPath();
        ctx.moveTo(0, ymain);
        ctx.bezierCurveTo(80,ymain, 40,ytag, 120, ytag);
        ctx.lineTo(160, ytag);
        ctx.stroke();
        
        var tagid = tag$.attr("data-tag-id"),
            relds = $(".related-datasheet-tag[data-tag-id=" + tagid + "]").parent().parent();
        
        if (this === selectedelement) {
            relds.css("opacity", 1);
        }
        
        relds.each(function(i) {
            var ds$ = $(this),
                dst = ds$.offset().top,
                dsh = ds$.outerHeight(),
                visible = ds$.is(":visible") && (dst - scroll < windowheight) && (dst + dsh - scroll > 0);
            if (visible) {
                var yds = Math.floor(dst + dsh / 2 - cvo.top);
                ctx.lineWidth = (this === selectedelement || tag$[0] === selectedelement ? 4 : 1);
                ctx.strokeStyle = colors[ds$.index() % colors.length];
                ctx.beginPath();
                ctx.moveTo(160, ytag);
                ctx.lineTo(200, ytag);
                ctx.bezierCurveTo(280,ytag, 280,yds, 320, yds);
                ctx.stroke();
                if (this === selectedelement) {
                    tag$.css("opacity",1);
                }
            }
        })
    });
}

$(function() {
    $(window).scroll(drawlinks);
    $(window).resize(drawlinks);
    $(".main-datasheet-tag").click(function() {
        var tag$ = $(this);
        if (tag$.hasClass("selected")) {
            $(".datasheet").show();
            tag$.removeClass("selected");
        } else {
            $(".datasheet").hide();
            var tagid = tag$.attr("data-tag-id");
            $(".related-datasheet-tag[data-tag-id=" + tagid + "]").parent().parent().show();
            $(".main-datasheet-tag").removeClass("selected");
            tag$.addClass("selected");
        }
        drawlinks();
    });
    $(".main-datasheet-tag, .datasheet").mouseover(function() {
        if (selectedelement !== this) {
            selectedelement = this;
            drawlinks();
        }
    }).mouseout(function() {
        if (selectedelement) {
            selectedelement = null;
            drawlinks();
        }
    });
    drawlinks();
});
