var gomNs = {
    languageCode: 'fr'
}

function showResults(data) {
    $("#contentcount").html('<b>'+data.count+'</b> ' + ngettext('notice', 'notices', data.count));
    var contentdata = data.contents;
    if (contentdata && contentdata.length) {
        var _htmlCl = '<ul id="contentlist">'
            + contentdata.map(function(_d) {
                var _html = '<li class="content-item"><h3>'
                    + _d.title
                    + '</h3>'
                    + ( typeof _d.coords == "object" ?
                        '<div class="maplet"><img src="http://maps.googleapis.com/maps/api/staticmap?center=47,1.5&zoom=4&size=160x160&maptype=roadmap&markers=color:red%7C'
                        + _d.coords.latitude
                        + ','
                        + _d.coords.longitude
                        + '&sensor=false" /><h4>Localisation&nbsp;: '
                        + _d.coords.city_name
                        + '</h4></div>'
                        : '')
                    + '<h4><a href="'
                    + _d.url
                    + '" target="_blank">'
                    + _d.url.replace(/(^.{40}).+(.{30}$)/m,'$1 &hellip; $2')
                    + '</a></h4><p>'
                    + _d.description.replace(/(^.{0,160})([\s]|$)(.*)/,'$1&hellip;')
                    + '</p><ul class="content-tags">'
                    + _d.tags.map(function(_t) {
                        return '<li class="content-tag-item"><a href="#" onclick="getContents(this.textContent.trim()); return false;" original-label="'
                            + _t.label
                            + '"'
                            + (_t.match ? ' class="tagmatch"' : '')
                            + '>'
                            + _t.translated_label
                            + '</a></li>';
                    }).join('')
                    + '</ul>';
                _html += '</li>';
                return _html;
            }).join('')
            + '</ul>';
        $("#contents").html(_htmlCl).scrollTop(0);
    }
    else {
        $("#contents").html("");
    }
}

function getContents(label) {
    $.getJSON(
        gomNs.urls['contentsbytag'],
        {
            label: label
        },
        showResults
    );
}

$(document).ready(function() {
    $(" #tagform ").submit(function() {
        return false;
    });
    var cache = {}, /*CACHE => http://jqueryui.com/demos/autocomplete/#remote-with-cache */
        lastXhr;
    $( "#tagsearch" ).autocomplete({
        source: function( request, response ) {
            var term = request.term;
            if ( term in cache ) {
                $("#tagsearch").removeClass("waiting");
                response( cache[ term ] );
                return;
            }
            $("#tagsearch").addClass("waiting");
            lastXhr = $.getJSON( gomNs.urls['tag_search'], request, function( data, status, xhr ) {
                cache[ term ] = data;
                if ( xhr === lastXhr ) {
                    response( data );
                    $("#tagsearch").removeClass("waiting");
                }
            });
        },
        minLength: 2,
        focus: function( event, ui ) {
            var _title = $('<h4>')
                .addClass("actitle")
                .html(
                    ui.item.value.replace(
                        new RegExp('('
                            + $("#tagsearch").val().replace(/(\W)/g, '\\$1')
                            + ')','gi') ,
                        '<strong>$1</strong>')
                );
            $(".wpinfo").html(_title);
            if (ui.item.thumbnail) {
                var _img = $('<img>')
                    .addClass("acimg")
                    .attr("src",ui.item.thumbnail);
                $(".wpinfo").append(_img);
            }
            if (ui.item.abstract) {
                var _abstract = $('<p>')
                    .addClass("acabstract")
                    .text( ui.item.abstract.replace(/(^.{0,240})([\s]|$)(.*)/,'$1…') );
                $(".wpinfo").append(_abstract);
            }
            $(".wpinfo").append('<div class="clear"></div>');
        },
        select: function( event, ui ) {
            getContents(ui.item.label);
        }
    })
    .data("autocomplete")._renderItem = function(ul, item) {
        var _contents = $('<a>'),
            _nb = $('<span>')
                .addClass("acnb")
                .text(item.nb),
            _title = $('<h4>')
                .addClass("actitle")
                .html(
                    item.value.replace(
                        new RegExp('('
                            + $("#tagsearch").val().replace(/(\W)/g, '\\$1')
                            + ')','gi') ,
                        '<strong>$1</strong>')
                );
        _contents.append(_nb).append(_title);
        return $( "<li>" )
            .data( "item.autocomplete", item )
            .append( _contents )
            .appendTo( ul );
    };
});
