# -*- coding: utf-8 -*-
'''
Created on Feb 28, 2012

@author: ymh
'''
from django.core.management.base import BaseCommand
from django.core.management import call_command
from optparse import make_option
import os.path


class Command(BaseCommand):

    args = "[<path to the data folder>]"
    option_list = BaseCommand.option_list + (
        make_option('-c', '--categories',
            action='store_true',
            dest='categories',
            default=False,
            help='load categories in db'),
    )


    def handle(self, *args, **options):        
        
        if len(args) == 0:
            data_path = os.path.abspath(os.path.join(os.path.basename(__file__),'../../../../data'))
        else:
            data_path = args[0]
        
        print("===========  MIGRATE ===========")
        call_command('syncdb', migrate=True)
        if options.get('categories', False):
            print("===========  QUERY WIKIPEDIA CATEGORY ===========")
            call_command('query_wikipedia_category', interactive=False, force=True)

        print("===========  QUERY DBPEDIA ===========")                
        call_command('query_dbpedia', interactive=False, force=True)
        print("===========  FILL TAG YEAR ===========")
        call_command('fill_tag_years')
        print("===========  GEOJSON TRANSFORM ===========")
        call_command('geojson_transform', os.path.join(data_path,'countries.geo.json'))
        print("===========  QUERY GEO INCLUSION ===========")
        call_command('query_geo_inclusion')
        print("===========  IMPORT INSEE CSV PASS 1 ===========")
        call_command('import_insee_csv', os.path.join(data_path,'villes.csv'))
        print("===========  IMPORT INSEE CSV PASS 2 ===========")
        call_command('import_insee_csv', os.path.join(data_path,'additional_cities.csv'))
        print("===========  IMPORT HDA INSEE CSV ===========")
        call_command('import_hda_insee_csv', os.path.join(data_path,'HDA_Insee.csv'))
        print("===========  QUERY CATEGORY INCLUSION ===========")
        call_command('query_category_inclusion', all=True, force=True, interactive=False)
        
        