/* Rkns.HdaNotices bin definition : search form and result rendering */

Rkns.HdaNotices = {
};

Rkns.HdaNotices.Search = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.lang = _opts.lang || "fr";
    this.image = _opts.image;
    this.url = _opts.url;
    //Uncomment the next line to add autocompletion
    //this.autoComplete();
};

Rkns.HdaNotices.Search.prototype.autoComplete = function() {
    var _this = this;
    this.renkan.$.find(".Rk-Web-Search-Input").on("change keyup paste", function() {
        if (_this.renkan.$.find(".Rk-Search-Current").hasClass(_this.getBgClass())){
	    	$.ajax({
	            url: _this.url + "?q=" + _this.renkan.$.find(".Rk-Web-Search-Input").val() + "&format=json&limit=10",
	            success: function(data){
	            	var results = [];
	            	if (typeof(data.results) != 'undefined'){
	            		data.results.forEach(function(result){
	                		results.push(result.title);
	                	});
	                  	_this.renkan.$.find(".Rk-Web-Search-Input").autocomplete({
	                  		source: results
	                  	});
	            	}
	            }
	        });
        }
    });
};

Rkns.HdaNotices.Search.prototype.getBgClass = function() {
    return "Rk-HdaNotices-Search-Icon";
};

Rkns.HdaNotices.Search.prototype.getSearchTitle = function() {
    return this.renkan.translate("Notices Hda");
};

Rkns.HdaNotices.Search.prototype.search = function(_q) {
    this.renkan.tabs.push(
        new Rkns.HdaNotices.Bin(this.renkan, {
            lang: this.lang,
            url: this.url,
            image: this.image,
            search: _q
        })
    );
};

Rkns.HdaNotices.Bin = Rkns.Utils.inherit(Rkns._BaseBin);

Rkns.HdaNotices.Bin.prototype.resultTemplate = Rkns._.template(
    '<li class="Rk-Wikipedia-Result Rk-Bin-Item" draggable="true" data-uri="<%-url%>" ' +
    'data-title="<%-title%>" data-description="<%-full_description%>" data-image="<%-image%>">' +
    '<img class="Rk-Wikipedia-Icon" src="<%-image%>"></div><h4 class="Rk-Wikipedia-Title"><a href="<%-url%>" target="_blank"><%=htitle%></a></h4>' +
    '<p class="Rk-Wikipedia-Snippet"><%=hdescription%></p></li>'
);

Rkns.HdaNotices.Bin.prototype._init = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.search = _opts.search;
    this.lang = _opts.lang || "fr";
    this.url = _opts.url;
    this.image = _opts.image;
    this.title_icon_$.addClass('Rk-HdaNotices-Title-Icon');
    this.title_$.html(this.search).addClass("Rk-HdaNotices-Title");
    this.refresh();
};

Rkns.HdaNotices.Bin.prototype.render = function(searchbase) {
    var search = searchbase || Rkns.Utils.regexpFromTextOrArray();
    var highlightrx = (search.isempty ? Rkns.Utils.regexpFromTextOrArray(this.search) : search);
    function highlight(_text) {
        return highlightrx.replace(_(_text).escape(), "<span class='searchmatch'>$1</span>");
    }
    var _html = "",
        _this = this,
        count = 0;
    Rkns._.each(this.data.results, function(_result) {
        var title = _result.title,
            url = _result.url,
            full_description = _result.description,
            description = _result.description.substr(0, _result.description.indexOf(" ", 170)) + "...",
            image = "http://www.histoiredesarts.culture.fr/images/pf/" + _result.hda_id + ".jpg";
        if (!search.isempty && !search.test(title) && !search.test(description)) {
            return;
        }
        count++;
        _html += _this.resultTemplate({
            url: url,
            title: title,
            htitle: highlight(title),
            full_description: full_description,
            description: description,
            hdescription: highlight(description),
            image: image
        });
    });
    _this.main_$.html(_html);
    if (!search.isempty && count) {
        this.count_$.text(count).show();
    } else {
        this.count_$.hide();
    }
    if (!search.isempty && !count) {
        this.$.hide();
    } else {
        this.$.show();
    }
    this.renkan.resizeBins();
};

Rkns.HdaNotices.Bin.prototype.refresh = function() {
    var _this = this;
    Rkns.$.ajax({
        url: this.url + "?q=" + encodeURIComponent(this.search) + "&format=json&limit=50",
        success: function(_data) {
            _this.data = _data;
            _this.render();
        }
    });
};


/* Rkns.HdaTags bin definition : search form and result rendering */

Rkns.HdaTags = {
};

Rkns.HdaTags.Search = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.lang = _opts.lang || "fr";
    this.image = _opts.image;
    this.url = _opts.url;
};

Rkns.HdaTags.Search.prototype.getBgClass = function() {
    return "Rk-HdaTags-Search-Icon";
};

Rkns.HdaTags.Search.prototype.getSearchTitle = function() {
    return this.renkan.translate("Tags Hda");
};

Rkns.HdaTags.Search.prototype.search = function(_q) {
    this.renkan.tabs.push(
        new Rkns.HdaTags.Bin(this.renkan, {
            lang: this.lang,
            url: this.url,
            image: this.image,
            search: _q
        })
    );
};

Rkns.HdaTags.Bin = Rkns.Utils.inherit(Rkns._BaseBin);

Rkns.HdaTags.Bin.prototype.resultTemplate = Rkns._.template(
    '<li class="Rk-Wikipedia-Result Rk-Bin-Item" draggable="true" data-uri="<%-url%>" ' +
    'data-title="<%-title%>" data-description="<%-full_description%>" data-image="<%-image%>">' +
    '<img class="Rk-Wikipedia-Icon" src="<%-image%>"></div><h4 class="Rk-Wikipedia-Title"><a href="<%-url%>" target="_blank"><%=htitle%></a></h4>' +
    '<p class="Rk-Wikipedia-Snippet"><%=hdescription%></p></li>'
);

Rkns.HdaTags.Bin.prototype._init = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.search = _opts.search;
    this.lang = _opts.lang || "fr";
    this.url = _opts.url;
    this.image = _opts.image;
    this.title_icon_$.addClass('Rk-HdaTags-Title-Icon');
    this.title_$.html(this.search).addClass("Rk-HdaTags-Title");
    this.refresh();
};

Rkns.HdaTags.Bin.prototype.render = function(searchbase) {
    var search = searchbase || Rkns.Utils.regexpFromTextOrArray();
    var highlightrx = (search.isempty ? Rkns.Utils.regexpFromTextOrArray(this.search) : search);
    function highlight(_text) {
        return highlightrx.replace(_(_text).escape(), "<span class='searchmatch'>$1</span>");
    }
    var _html = "",
        _this = this,
        count = 0;
    Rkns._.each(this.data, function(_result) {
        var title = _result.value,
            url = _result.url,
            full_description = _result.abstract ? _result.abstract : "",
            description = ( (full_description.indexOf(" ", 170) < 0 ) ? full_description : (full_description.substr(0, full_description.indexOf(" ", 170)) + "...") ),
            image = _result.thumbnail;
        if (!search.isempty && !search.test(title) && !search.test(description)) {
            return;
        }
        count++;
        _html += _this.resultTemplate({
            url: url,
            title: title,
            htitle: highlight(title),
            full_description: full_description,
            description: description,
            hdescription: highlight(description),
            image: image
        });
    });
    _this.main_$.html(_html);
    if (!search.isempty && count) {
        this.count_$.text(count).show();
    } else {
        this.count_$.hide();
    }
    if  (!search.isempty && !count) {
        this.$.hide();
    } else {
        this.$.show();
    }
    this.renkan.resizeBins();
};

Rkns.HdaTags.Bin.prototype.refresh = function() {
    var _this = this;
    Rkns.$.ajax({
        url: this.url + "?term=" + encodeURIComponent(this.search) + "&format=json&count=50&count_notices=0",
        success: function(_data) {
            _this.data = _data;
            _this.render();
        }
    });
};
