gomNs.countryLabels = {
AFG: 'Afghanistan',
AGO: 'Angola',
ALB: 'Albanie',
ARG: 'Argentine',
ARM: 'Arménie',
ATA: 'Antarctique',
AUS: 'Australie',
AUT: 'Autriche',
AZE: 'Azerbaïdjan',
BDI: 'Burundi',
BEL: 'Belgique',
BEN: 'Bénin',
BGR: 'Bulgarie',
BIH: 'Bosnie-Herzégovine',
BOL: 'Bolivie',
BRA: 'Brésil',
BRN: 'Brunei',
CAF: 'République centrafricaine',
CAN: 'Canada',
CHE: 'Suisse',
CHL: 'Chili',
CHN: 'Chine',
CIV: 'Côte d\'Ivoire',
CMR: 'Cameroun',
COD: 'République démocratique du Congo',
CZE: 'République tchèque',
DEU: 'Allemagne',
DNK: 'Danemark',
DZA: 'Algérie',
EGY: 'Égypte',
ESP: 'Espagne',
EST: 'Estonie',
ETH: 'Éthiopie',
FIN: 'Finlande',
FRA: 'France',
GAB: 'Gabon',
GBR: 'Royaume-Uni',
GGY: 'Guernesey',
GHA: 'Ghana',
GLP: 'Guadeloupe',
GRC: 'Grèce',
GUF: 'Guyane',
HTI: 'Haïti',
HUN: 'Hongrie',
IDN: 'Indonésie',
IND: 'Inde',
IRL: 'Irlande',
IRN: 'Iran',
ISL: 'Islande',
ISR: 'Israël',
ITA: 'Italie',
JAM: 'Jamaïque',
JEY: 'Jersey',
JPN: 'Japon',
KAZ: 'Kazakhstan',
KGZ: 'Kirghizistan',
KHM: 'Cambodge',
LBN: 'Liban',
LTU: 'Lituanie',
LVA: 'Lettonie',
MAR: 'Maroc',
MDA: 'Moldavie',
MEX: 'Mexique',
MLI: 'Mali',
MLT: 'Malte',
MMR: 'Birmanie',
MNG: 'Mongolie',
MOZ: 'Mozambique',
MTQ: 'Martinique',
NCL: 'Nouvelle-Calédonie',
NER: 'Niger',
NGA: 'Nigeria',
NLD: 'Pays-Bas',
NOR: 'Norvège',
NPL: 'Népal',
NZL: 'Nouvelle-Zélande',
PAK: 'Pakistan',
PHL: 'Philippines',
PNG: 'Papouasie-Nouvelle-Guinée',
POL: 'Pologne',
PRT: 'Portugal',
PSE: 'Palestine',
PYF: 'Polynésie française',
ROU: 'Roumanie',
RUS: 'Russie',
SDN: 'Soudan',
SEN: 'Sénégal',
SGP: 'Singapour',
SLV: 'Salvador',
SVK: 'Slovaquie',
SVN: 'Slovénie',
SWE: 'Suède',
SYR: 'Syrie',
TCD: 'Tchad',
THA: 'Thaïlande',
TJK: 'Tadjikistan',
TTO: 'Trinité-et-Tobago',
TUN: 'Tunisie',
TUR: 'Turquie',
UGA: 'Ouganda',
UKR: 'Ukraine',
USA: 'États-Unis',
UZB: 'Ouzbékistan',
VNM: 'Viêt Nam',
ZAF: 'Afrique du Sud'
}

function polygon_to_gmap(polycoords, isocode) {
    var _opts =  {
        strokeColor: "#000000",
        strokeWeight: .5,
        fillColor: "#7070a0",
        fillOpacity: .8,
        title: isocode
    }
    _opts.paths = polycoords.map(function(path) {
        return path.map(function(coord) {
            return new google.maps.LatLng(coord[1], coord[0]);
        });
    });
    var _polygon = new google.maps.Polygon(_opts);
    _polygon.setMap(gomNs.map);
    if (gomNs.countryLabels[isocode]) {
        google.maps.event.addListener(_polygon, 'click', function(a,b) {
            addFilter('country', isocode);
        })
    }
    return _polygon;
}

function showCountriesGmap(geoJson) {
    gomNs.countries = {};
    _(geoJson.features).each(function(feature) {
        var _el = { "label" : gomNs.countryLabels[feature.id] };
        if (feature.id == 'ATA') {
            _el.gPolygons = [];
        } else {
            switch(feature.geometry.type) {
                case('Polygon'):
                    _el.gPolygons = [ polygon_to_gmap(feature.geometry.coordinates, feature.id) ];
                break;
                case('MultiPolygon'):
                    _el.gPolygons = feature.geometry.coordinates.map(function(polygon) {
                        return polygon_to_gmap(polygon, feature.id);
                    })
                break;
            }
        }
        gomNs.countries[feature.id] = _el;
    });
}

function showCountriesLeaflet(geoJson) {
    gomNs.countries = {};
    var gJ = new L.GeoJSON();
    gJ.on('featureparse', function(_f) {
        var isocode = _f.id;
        _f.layer.setStyle({
            color: "#000000",
            weight: .5,
            fillColor: "#7070a0",
            fillOpacity: .8
        });
        if (gomNs.countryLabels[isocode]) {
            _f.layer.on('click', function() {
                addFilter('country', isocode);
            });
        }
        gomNs.countries[_f.id] = _f.layer;
    });
    gJ.addGeoJSON(geoJson);
    gomNs.map.addLayer(gJ);
}
