# -*- coding: utf-8 -*-
'''
Exporte en csv les catégories wikipédia utilisées dans HDALab.

**Usage**: ``django-admin export_wpcategory_csv [options] <chemin_vers_le_fichier_csv>``

**Options spécifiques:**

    - *\-\-encoding* : encodage des fichier, le défaut est `latin-1`.
    - *\-f* : force l'écrasement du fichier csv de sortie.

'''
from django.core.management.base import BaseCommand, CommandError
from optparse import make_option
from hdalab.management.utils import UnicodeWriter
from hdabo.wp_utils import normalize_tag
from hdalab.models.categories import WpCategory
from django.utils.http import urlquote
from hdabo.utils import show_progress

class Command(BaseCommand):
    '''
    Command to export tags
    '''
    args = '<path_to_csv_file>'
    options = '[-e|--encoding csv file encoding]|[-f|--force force file overwrite]'
    help = """export csv files for hdabo
Options:
    -e, --encoding : files encoding. default to latin-1
    -f, --force : force file overwrite
    """

    option_list = BaseCommand.option_list + (
        make_option("-e","--encoding",
            action='store',
            type='string',
            dest='encoding',
            default="utf-8",
            help='file encoding, default utf-8'),
        make_option("-f","--force",
            action='store_true',
            dest='force',
            default=False,
            help='force file overwrite'),
        )

    def handle(self, *args, **options):

        if len(args) == 0 or not args[0]:
            raise CommandError("Gives at last one csv file to export")

        self.encoding = options.get("encoding", "utf-8")
        self.force = options.get("force", False)
        self.path = args[0].strip()
        self.interactive = options.get("interactive",True)

        file = None
        try:
            try:
                file = open(self.path,'r')
                if (not self.force) and self.interactive:
                    print self.path
                    resp = raw_input("export file already exists. override ? type yes to continue : ")
                    if resp is not None and (resp.lower() == "yes" or resp.lower() == "y"):
                        self.force = True
                        # clear file
                    else:
                        return "error"
                elif not self.interactive and not self.force:
                    print "Export file %s already exists. Exit." % (self.path)
                    return "error"

                file.close()
                file = open(self.path,'w')
            except IOError:
                file = open(self.path,'w')

            csv = UnicodeWriter(file, doublequote=False, escapechar="\\", encoding=self.encoding)
            writer = None

            qs = WpCategory.objects.filter(tagwpcategory__hidden=False).distinct()

            total = qs.count()

            for i,wpcat in enumerate(qs):
                writer = show_progress(i+1, total, wpcat.label, 50, writer)
                nb_ds = 0
                for tag in wpcat.tagwpcategory_set.all():
                    nb_ds += tag.tag.datasheet_set.count()

                csv.writerow([wpcat.label, u"http://fr.wikipedia.org/wiki/Catégorie:%s" % urlquote(normalize_tag(wpcat.label)), nb_ds])

        finally:
            if file is not None:
                file.close()
