# -*- coding: utf-8 -*-
'''
Created on Jan 26, 2012

@author: ymh
'''
from django.db import models
from hdabo.models import Tag


class WpCategory(models.Model):
    """
    Une catégorie Wikipedia.

    :cvar str label: Le label de la catégorie.
    """
    label = models.CharField(max_length=2048, unique=True, blank=False, null=False)

    def __unicode__(self):
        return unicode(self.label)

    class Meta:
        app_label = 'hdalab'
        verbose_name_plural = "WpCategories"

class TagWpCategory(models.Model):
    """
    Relie une catégorie Wikipedia à un tag.

    :cvar object tag: Le tag.
    :cvar object wp_category: La categorie wikipedia.
    :cvar bool hidden: Indique si la catégorie est cachée ou pas.
    """
    tag = models.ForeignKey(Tag, related_name="wp_categories")
    wp_category = models.ForeignKey(WpCategory, related_name="tags")
    hidden = models.BooleanField(blank=False, null=False, default=False)

    class Meta:
        app_label = 'hdalab'
        unique_together = ('tag', 'wp_category', 'hidden')


class TagInfobox(models.Model):
    """
    Contenu de l'infobox wikipedia pour un tag.

    :cvar object tag: Le tag
    :cvar str name: Le nom (type) de l'infobox.
    :cvar str source: Le code source de l'infobox.
    :cvar int revision_id: Numéro de révision de l'infobox.
    """

    tag = models.ForeignKey(Tag, related_name="infoboxes")
    name = models.CharField(max_length=2048, unique=False, blank=False, null=False)
    source = models.TextField(unique=False, blank=True, null=True)
    revision_id = models.BigIntegerField(unique=False, blank=True, null=True)

    class Meta:
        app_label = 'hdalab'
        unique_together = ('tag','name','revision_id')


class InfoboxParameter(models.Model):
    """
    Valeurs de paramêtre d'une infobox Wikipedia.

    :cvar object tag_infobox: L'objet :class:TagInfobox.
    :cvar str param_name: Nom du paramêtre.
    :cvar str param_value: Valeur du paramêtre.
    """

    tag_infobox = models.ForeignKey(TagInfobox)
    param_name = models.CharField(max_length=2048, unique=False, blank=False, null=False)
    param_value = models.TextField(unique=False, blank=True, null=True)

    class Meta:
        app_label = 'hdalab'
        unique_together = ('tag_infobox','param_name')

# Added on 02/07/2012

class WpCategoryInclusion(models.Model):
    """
    Classe permettant de modéliser l'arbre de catégorie Wikipedia.

    :cvar object parent_category: La catégorie parente.
    :cvar object child_category: La catégorie enfant.
    """

    parent_category = models.ForeignKey(WpCategory, related_name="child_categories")
    child_category = models.ForeignKey(WpCategory, related_name="parent_categories")

    class Meta:
        app_label = 'hdalab'
        unique_together = ('parent_category','child_category')
