# -*- coding: utf-8 -*-
'''
Created on Jul 01, 2014

@author: tc
'''
from datetime import datetime
from django.conf import settings
from django.db.models import Q
from django.http.response import HttpResponse
from django.views.generic import View
from django.views.decorators.csrf import csrf_exempt
from hdabo.models import Tag, Datasheet, TaggedSheet
from hdalab.views.ajax import filter_generic
import json
import uuid

import logging
logger = logging.getLogger(__name__)


class RenkanGetPut(View):
    
    @csrf_exempt
    def dispatch(self, *args, **kwargs):
        return super(RenkanGetPut, self).dispatch(*args, **kwargs)
    
    def get(self, request):
        #file_path = settings.JSON_TEST_PATH
        #content = open(file_path,"r")
        
        now = datetime.now().strftime("%Y-%m-%d %H:%M")
        
        content = {
          "id": unicode(uuid.uuid1()),
          "title": "Renkan généré " + now,
          "description": "(empty description)",
          "created": now,
          "updated": now,
          "nodes": [],
          "edges": [],
          "views": [],
          "users": [],
        }
        
        # Get tags and countries
        labels = request.GET.get("label", "").split(",")
        countries = request.GET.get("country", "").split(",")
        # Tags arrive with french label, countries with dbpedia uri
        label_list = [t for t in labels if t!=""]
        country_list = [c for c in countries if c!=""]
        all_tags = Tag.objects.filter( Q(label__in=label_list) | Q(dbpedia_uri__in=country_list) )
        
        project_id = unicode(uuid.uuid1())
        
        for i,t in enumerate(all_tags):
            content["nodes"].append({
              "id": unicode(uuid.uuid1()),
              "title": t.label,
              "description": t.dbpedia_uri,
              "uri": t.dbpedia_uri,
              "position": {
                "x": 0,
                "y": 100*i
              },
              "image": None,
              "size": 0,
              "project_id": project_id,
              #"created_by": "roster_user-84fe909f-ba37-48e6-a25f-9d2f129a95b7"
            })
        
        # Get datasheets from ajax filter search
        filter_output = filter_generic(request.GET.get('lang',request.LANGUAGE_CODE), None, ",".join(label_list), ",".join(country_list))
        filter_output = json.loads(filter_output)
        for i,c in enumerate(filter_output["contents"]):
            content["nodes"].append({
              "id": unicode(uuid.uuid1()),
              "title": c["title"],
              "description": c["description"],
              "uri": c["url"],
              "position": {
                "x": 200,
                "y": 100*i - 50
              },
              "image": None,
              "size": 0,
              "project_id": project_id,
              #"created_by": "roster_user-84fe909f-ba37-48e6-a25f-9d2f129a95b7"
            })
        
        
        
        return HttpResponse(json.dumps(content), content_type="application/json")
    
    
    def put(self, request):
        
        return HttpResponse("OK")
    
