# -*- coding: utf-8 -*-
'''
Created on Jun 20, 2012

@author: ymh
'''
from django.core.management.base import NoArgsCommand
from django.core.management.color import no_style
from django.db import transaction,connection
from django.db.models import Count
from hdabo.models import Tag
from hdabo.utils import show_progress
from optparse import make_option
import math
import sys


class Command(NoArgsCommand):
    '''
    remove orphan tags and merge duplicates (the key is the dbpedia uri) 
    '''


    def handle_noargs(self, **options):
        '''
        do the work
        '''

        # merge duplicate tags
        cursor = connection.cursor()
        cursor.execute("select label, dbpedia_uri from hdabo_tag group by label,dbpedia_uri having count(label) > 1")
        
        for label,_ in cursor:
            qs = Tag.objects.filter(label=label).annotate(num_ds=Count('datasheet')).order_by('-num_ds')
            ref_tag = None
            for t in qs:
                print("label : %d : %s, num_ds: %d"%(t.id,t.label, t.num_ds))
                if ref_tag is None:
                    ref_tag = t
                else:
                    for ts in t.taggedsheet_set.all():
                        pass
                        print("changing tag %d to %d" %(ts.tag.id, ref_tag.id) )
                        ts.tag = ref_tag
                        ts.save()
        
        # remove ophans tags
        
        orphans_tags = Tag.objects.annotate(num_ds=Count('datasheet')).filter(num_ds=0)
        
        print("nb Orphans : %d" % orphans_tags.count())
                
        #delete
        orphans_tags.delete()

        