# -*- coding: utf-8 -*-
'''
Created on Jul 01, 2014

@author: tc
'''

from django.views.generic import TemplateView
from hdalab.models.renkan import HdalabRenkan
from hdabo.views import Folders, AddOrUpdateFolder, DeleteFolder

import logging
logger = logging.getLogger(__name__)


class ManageRenkans(TemplateView):
    template_name = "editorial/manage_renkans.html"
    
    def get_context_data(self, **kwargs):
        context = super(ManageRenkans, self).get_context_data(**kwargs)
        
        context["renkan_list"] = HdalabRenkan.objects.exclude(state=HdalabRenkan.EDITION).select_related("renkan", "renkan__owner").order_by("-renkan__modification_date")
        
        return context


class HdalabFolders(Folders):
    template_name = "editorial/folders.html"



class HdalabAddOrUpdateFolder(AddOrUpdateFolder):
    template_name = "editorial/add_or_update_folder.html"
    redirect_view = 'hdalab_folders'



class HdalabDeleteFolder(DeleteFolder):
    redirect_view = 'hdalab_folders'