#@PydevCodeAnalysisIgnore
# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models

class Migration(SchemaMigration):

    def forwards(self, orm):
        
        #create auth_user table here to adjust to application dependencies
        db.create_table('auth_user', (
            (u'id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('password', self.gf('django.db.models.fields.CharField')(max_length=128)),
            ('last_login', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now)),
            ('is_superuser', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('username', self.gf('django.db.models.fields.CharField')(unique=True, max_length=30)),
            ('first_name', self.gf('django.db.models.fields.CharField')(max_length=30, blank=True)),
            ('last_name', self.gf('django.db.models.fields.CharField')(max_length=30, blank=True)),
            ('email', self.gf('django.db.models.fields.EmailField')(max_length=75, blank=True)),
            ('is_staff', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('is_active', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('date_joined', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now)),
        ))

        
        # Adding model 'Organisation'
        db.create_table('hdabo_organisation', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('hda_id', self.gf('django.db.models.fields.CharField')(unique=True, max_length=512)),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=512)),
            ('location', self.gf('django.db.models.fields.CharField')(max_length=512, null=True, blank=True)),
            ('website', self.gf('django.db.models.fields.CharField')(max_length=2048, null=True, blank=True)),
        ))
        db.send_create_signal('hdabo', ['Organisation'])

        # Adding model 'Author'
        db.create_table('hdabo_author', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('hda_id', self.gf('django.db.models.fields.CharField')(unique=True, max_length=512)),
            ('lastname', self.gf('django.db.models.fields.CharField')(max_length=512, null=True, blank=True)),
            ('firstname', self.gf('django.db.models.fields.CharField')(max_length=512, null=True, blank=True)),
        ))
        db.send_create_signal('hdabo', ['Author'])

        # Adding model 'TimePeriod'
        db.create_table('hdabo_timeperiod', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('label', self.gf('django.db.models.fields.CharField')(max_length=512)),
            ('school_period', self.gf('django.db.models.fields.IntegerField')()),
        ))
        db.send_create_signal('hdabo', ['TimePeriod'])

        # Adding unique constraint on 'TimePeriod', fields ['label', 'school_period']
        db.create_unique('hdabo_timeperiod', ['label', 'school_period'])

        # Adding model 'Domain'
        db.create_table('hdabo_domain', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('label', self.gf('django.db.models.fields.CharField')(max_length=512)),
            ('school_period', self.gf('django.db.models.fields.IntegerField')()),
        ))
        db.send_create_signal('hdabo', ['Domain'])

        # Adding unique constraint on 'Domain', fields ['label', 'school_period']
        db.create_unique('hdabo_domain', ['label', 'school_period'])

        # Adding model 'DocumentFormat'
        db.create_table('hdabo_documentformat', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('label', self.gf('django.db.models.fields.CharField')(unique=True, max_length=512)),
        ))
        db.send_create_signal('hdabo', ['DocumentFormat'])

        # Adding model 'TagCategory'
        db.create_table('hdabo_tagcategory', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('label', self.gf('django.db.models.fields.CharField')(unique=True, max_length=512)),
        ))
        db.send_create_signal('hdabo', ['TagCategory'])

        # Adding model 'Tag'
        db.create_table('hdabo_tag', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('label', self.gf('django.db.models.fields.CharField')(max_length=1024, db_index=True)),
            ('normalized_label', self.gf('django.db.models.fields.CharField')(max_length=1024, db_index=True)),
            ('original_label', self.gf('django.db.models.fields.CharField')(max_length=1024)),
            ('alias', self.gf('django.db.models.fields.CharField')(max_length=1024, null=True, blank=True)),
            ('category', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.TagCategory'], null=True, blank=True)),
            ('wikipedia_url', self.gf('django.db.models.fields.URLField')(max_length=2048, null=True, blank=True)),
            ('wikipedia_pageid', self.gf('django.db.models.fields.BigIntegerField')(null=True, blank=True)),
            ('url_status', self.gf('django.db.models.fields.IntegerField')(default=None, null=True, blank=True)),
            ('dbpedia_uri', self.gf('django.db.models.fields.URLField')(max_length=2048, null=True, blank=True)),
            ('popularity', self.gf('django.db.models.fields.IntegerField')(default=0, db_index=True)),
        ))
        db.send_create_signal('hdabo', ['Tag'])

        # Adding unique constraint on 'Tag', fields ['label', 'original_label', 'url_status']
        db.create_unique('hdabo_tag', ['label', 'original_label', 'url_status'])

        # Adding model 'Location'
        db.create_table('hdabo_location', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=512)),
            ('insee', self.gf('django.db.models.fields.CharField')(unique=True, max_length=5)),
        ))
        db.send_create_signal('hdabo', ['Location'])

        # Adding model 'Datasheet'
        db.create_table('hdabo_datasheet', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('hda_id', self.gf('django.db.models.fields.CharField')(unique=True, max_length=512)),
            ('author', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.Author'], null=True, blank=True)),
            ('organisation', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.Organisation'])),
            ('title', self.gf('django.db.models.fields.CharField')(max_length=2048)),
            ('description', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('url', self.gf('django.db.models.fields.URLField')(max_length=2048, null=True, blank=True)),
            ('town', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.Location'], null=True, blank=True)),
            ('format', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.DocumentFormat'], null=True, blank=True)),
            ('original_creation_date', self.gf('django.db.models.fields.DateField')()),
            ('original_modification_date', self.gf('django.db.models.fields.DateField')()),
            ('modification_datetime', self.gf('django.db.models.fields.DateTimeField')(auto_now=True, blank=True)),
            ('validation_date', self.gf('django.db.models.fields.DateTimeField')(null=True, blank=True)),
            ('validated', self.gf('django.db.models.fields.BooleanField')(default=False, db_index=True)),
            ('validator', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['auth.User'], null=True, blank=True)),
            ('manual_order', self.gf('django.db.models.fields.BooleanField')(default=False, db_index=True)),
        ))
        db.send_create_signal('hdabo', ['Datasheet'])

        # Adding model 'TaggedSheet'
        db.create_table('hdabo_taggedsheet', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('datasheet', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.Datasheet'])),
            ('tag', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.Tag'])),
            ('original_order', self.gf('django.db.models.fields.IntegerField')(default=0)),
            ('order', self.gf('django.db.models.fields.IntegerField')(default=0, db_index=True)),
            ('index_note', self.gf('django.db.models.fields.FloatField')(default=0.0, db_index=True)),
            ('wikipedia_revision_id', self.gf('django.db.models.fields.BigIntegerField')(null=True, blank=True)),
        ))
        db.send_create_signal('hdabo', ['TaggedSheet'])

        # Adding model 'Datasheet_domains'
        db.create_table('hdabo_datasheet_domains', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('datasheet', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.Datasheet'])),
            ('sort_value', self.gf('django.db.models.fields.IntegerField')()),
            ('domain', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.Domain'])),
        ))
        db.send_create_signal('hdabo', ['Datasheet_domains'])

        # Adding model 'Datasheet_highschool_periods'
        db.create_table('hdabo_datasheet_highschool_periods', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('datasheet', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.Datasheet'])),
            ('sort_value', self.gf('django.db.models.fields.IntegerField')()),
            ('timeperiod', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.TimePeriod'])),
        ))
        db.send_create_signal('hdabo', ['Datasheet_highschool_periods'])

        # Adding model 'Datasheet_highschool_themes'
        db.create_table('hdabo_datasheet_highschool_themes', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('datasheet', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.Datasheet'])),
            ('sort_value', self.gf('django.db.models.fields.IntegerField')()),
            ('domain', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.Domain'])),
        ))
        db.send_create_signal('hdabo', ['Datasheet_highschool_themes'])

        # Adding model 'Datasheet_college_periods'
        db.create_table('hdabo_datasheet_college_periods', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('datasheet', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.Datasheet'])),
            ('sort_value', self.gf('django.db.models.fields.IntegerField')()),
            ('timeperiod', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.TimePeriod'])),
        ))
        db.send_create_signal('hdabo', ['Datasheet_college_periods'])

        # Adding model 'Datasheet_college_themes'
        db.create_table('hdabo_datasheet_college_themes', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('datasheet', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.Datasheet'])),
            ('sort_value', self.gf('django.db.models.fields.IntegerField')()),
            ('domain', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.Domain'])),
        ))
        db.send_create_signal('hdabo', ['Datasheet_college_themes'])

        # Adding model 'Datasheet_primary_periods'
        db.create_table('hdabo_datasheet_primary_periods', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('datasheet', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.Datasheet'])),
            ('sort_value', self.gf('django.db.models.fields.IntegerField')()),
            ('timeperiod', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.TimePeriod'])),
        ))
        db.send_create_signal('hdabo', ['Datasheet_primary_periods'])

        # Adding model 'Datasheet_primary_themes'
        db.create_table('hdabo_datasheet_primary_themes', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('datasheet', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.Datasheet'])),
            ('sort_value', self.gf('django.db.models.fields.IntegerField')()),
            ('domain', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['hdabo.Domain'])),
        ))
        db.send_create_signal('hdabo', ['Datasheet_primary_themes'])


    def backwards(self, orm):
        
        # Removing unique constraint on 'Tag', fields ['label', 'original_label', 'url_status']
        db.delete_unique('hdabo_tag', ['label', 'original_label', 'url_status'])

        # Removing unique constraint on 'Domain', fields ['label', 'school_period']
        db.delete_unique('hdabo_domain', ['label', 'school_period'])

        # Removing unique constraint on 'TimePeriod', fields ['label', 'school_period']
        db.delete_unique('hdabo_timeperiod', ['label', 'school_period'])

        # Deleting model 'Organisation'
        db.delete_table('hdabo_organisation')

        # Deleting model 'Author'
        db.delete_table('hdabo_author')

        # Deleting model 'TimePeriod'
        db.delete_table('hdabo_timeperiod')

        # Deleting model 'Domain'
        db.delete_table('hdabo_domain')

        # Deleting model 'DocumentFormat'
        db.delete_table('hdabo_documentformat')

        # Deleting model 'TagCategory'
        db.delete_table('hdabo_tagcategory')

        # Deleting model 'Tag'
        db.delete_table('hdabo_tag')

        # Deleting model 'Location'
        db.delete_table('hdabo_location')

        # Deleting model 'Datasheet'
        db.delete_table('hdabo_datasheet')

        # Deleting model 'TaggedSheet'
        db.delete_table('hdabo_taggedsheet')

        # Deleting model 'Datasheet_domains'
        db.delete_table('hdabo_datasheet_domains')

        # Deleting model 'Datasheet_highschool_periods'
        db.delete_table('hdabo_datasheet_highschool_periods')

        # Deleting model 'Datasheet_highschool_themes'
        db.delete_table('hdabo_datasheet_highschool_themes')

        # Deleting model 'Datasheet_college_periods'
        db.delete_table('hdabo_datasheet_college_periods')

        # Deleting model 'Datasheet_college_themes'
        db.delete_table('hdabo_datasheet_college_themes')

        # Deleting model 'Datasheet_primary_periods'
        db.delete_table('hdabo_datasheet_primary_periods')

        # Deleting model 'Datasheet_primary_themes'
        db.delete_table('hdabo_datasheet_primary_themes')
        
        # delete table auth_user
        db.delete_table('auth_user')


    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'hdabo.author': {
            'Meta': {'object_name': 'Author'},
            'firstname': ('django.db.models.fields.CharField', [], {'max_length': '512', 'null': 'True', 'blank': 'True'}),
            'hda_id': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '512'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'lastname': ('django.db.models.fields.CharField', [], {'max_length': '512', 'null': 'True', 'blank': 'True'})
        },
        'hdabo.datasheet': {
            'Meta': {'object_name': 'Datasheet'},
            'author': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.Author']", 'null': 'True', 'blank': 'True'}),
            'college_periods': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'college_periods_datasheets'", 'symmetrical': 'False', 'through': "orm['hdabo.Datasheet_college_periods']", 'to': "orm['hdabo.TimePeriod']"}),
            'college_themes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'college_themes_datasheets'", 'symmetrical': 'False', 'through': "orm['hdabo.Datasheet_college_themes']", 'to': "orm['hdabo.Domain']"}),
            'description': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'domains': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'datasheets'", 'symmetrical': 'False', 'through': "orm['hdabo.Datasheet_domains']", 'to': "orm['hdabo.Domain']"}),
            'format': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.DocumentFormat']", 'null': 'True', 'blank': 'True'}),
            'hda_id': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '512'}),
            'highschool_periods': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'highschool_periods_datasheets'", 'symmetrical': 'False', 'through': "orm['hdabo.Datasheet_highschool_periods']", 'to': "orm['hdabo.TimePeriod']"}),
            'highschool_themes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'highschool_themes_datasheets'", 'symmetrical': 'False', 'through': "orm['hdabo.Datasheet_highschool_themes']", 'to': "orm['hdabo.Domain']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'manual_order': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'db_index': 'True'}),
            'modification_datetime': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'organisation': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.Organisation']"}),
            'original_creation_date': ('django.db.models.fields.DateField', [], {}),
            'original_modification_date': ('django.db.models.fields.DateField', [], {}),
            'primary_periods': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'primary_periods_datasheets'", 'symmetrical': 'False', 'through': "orm['hdabo.Datasheet_primary_periods']", 'to': "orm['hdabo.TimePeriod']"}),
            'primary_themes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'primary_themes_datasheets'", 'symmetrical': 'False', 'through': "orm['hdabo.Datasheet_primary_themes']", 'to': "orm['hdabo.Domain']"}),
            'tags': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['hdabo.Tag']", 'through': "orm['hdabo.TaggedSheet']", 'symmetrical': 'False'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '2048'}),
            'town': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.Location']", 'null': 'True', 'blank': 'True'}),
            'url': ('django.db.models.fields.URLField', [], {'max_length': '2048', 'null': 'True', 'blank': 'True'}),
            'validated': ('django.db.models.fields.BooleanField', [], {'default': 'False', 'db_index': 'True'}),
            'validation_date': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'validator': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['auth.User']", 'null': 'True', 'blank': 'True'})
        },
        'hdabo.datasheet_college_periods': {
            'Meta': {'ordering': "['sort_value']", 'object_name': 'Datasheet_college_periods'},
            'datasheet': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.Datasheet']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'sort_value': ('django.db.models.fields.IntegerField', [], {}),
            'timeperiod': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.TimePeriod']"})
        },
        'hdabo.datasheet_college_themes': {
            'Meta': {'ordering': "['sort_value']", 'object_name': 'Datasheet_college_themes'},
            'datasheet': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.Datasheet']"}),
            'domain': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.Domain']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'sort_value': ('django.db.models.fields.IntegerField', [], {})
        },
        'hdabo.datasheet_domains': {
            'Meta': {'ordering': "['sort_value']", 'object_name': 'Datasheet_domains'},
            'datasheet': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.Datasheet']"}),
            'domain': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.Domain']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'sort_value': ('django.db.models.fields.IntegerField', [], {})
        },
        'hdabo.datasheet_highschool_periods': {
            'Meta': {'ordering': "['sort_value']", 'object_name': 'Datasheet_highschool_periods'},
            'datasheet': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.Datasheet']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'sort_value': ('django.db.models.fields.IntegerField', [], {}),
            'timeperiod': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.TimePeriod']"})
        },
        'hdabo.datasheet_highschool_themes': {
            'Meta': {'ordering': "['sort_value']", 'object_name': 'Datasheet_highschool_themes'},
            'datasheet': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.Datasheet']"}),
            'domain': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.Domain']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'sort_value': ('django.db.models.fields.IntegerField', [], {})
        },
        'hdabo.datasheet_primary_periods': {
            'Meta': {'ordering': "['sort_value']", 'object_name': 'Datasheet_primary_periods'},
            'datasheet': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.Datasheet']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'sort_value': ('django.db.models.fields.IntegerField', [], {}),
            'timeperiod': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.TimePeriod']"})
        },
        'hdabo.datasheet_primary_themes': {
            'Meta': {'ordering': "['sort_value']", 'object_name': 'Datasheet_primary_themes'},
            'datasheet': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.Datasheet']"}),
            'domain': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.Domain']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'sort_value': ('django.db.models.fields.IntegerField', [], {})
        },
        'hdabo.documentformat': {
            'Meta': {'object_name': 'DocumentFormat'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'label': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '512'})
        },
        'hdabo.domain': {
            'Meta': {'unique_together': "(('label', 'school_period'),)", 'object_name': 'Domain'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'label': ('django.db.models.fields.CharField', [], {'max_length': '512'}),
            'school_period': ('django.db.models.fields.IntegerField', [], {})
        },
        'hdabo.location': {
            'Meta': {'object_name': 'Location'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'insee': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '5'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '512'})
        },
        'hdabo.organisation': {
            'Meta': {'object_name': 'Organisation'},
            'hda_id': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '512'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'location': ('django.db.models.fields.CharField', [], {'max_length': '512', 'null': 'True', 'blank': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '512'}),
            'website': ('django.db.models.fields.CharField', [], {'max_length': '2048', 'null': 'True', 'blank': 'True'})
        },
        'hdabo.tag': {
            'Meta': {'unique_together': "(('label', 'original_label', 'url_status'),)", 'object_name': 'Tag'},
            'alias': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'}),
            'category': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.TagCategory']", 'null': 'True', 'blank': 'True'}),
            'dbpedia_uri': ('django.db.models.fields.URLField', [], {'max_length': '2048', 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'label': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'db_index': 'True'}),
            'normalized_label': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'db_index': 'True'}),
            'original_label': ('django.db.models.fields.CharField', [], {'max_length': '1024'}),
            'popularity': ('django.db.models.fields.IntegerField', [], {'default': '0', 'db_index': 'True'}),
            'url_status': ('django.db.models.fields.IntegerField', [], {'default': 'None', 'null': 'True', 'blank': 'True'}),
            'wikipedia_pageid': ('django.db.models.fields.BigIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'wikipedia_url': ('django.db.models.fields.URLField', [], {'max_length': '2048', 'null': 'True', 'blank': 'True'})
        },
        'hdabo.tagcategory': {
            'Meta': {'object_name': 'TagCategory'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'label': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '512'})
        },
        'hdabo.taggedsheet': {
            'Meta': {'object_name': 'TaggedSheet'},
            'datasheet': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.Datasheet']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'index_note': ('django.db.models.fields.FloatField', [], {'default': '0.0', 'db_index': 'True'}),
            'order': ('django.db.models.fields.IntegerField', [], {'default': '0', 'db_index': 'True'}),
            'original_order': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'tag': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['hdabo.Tag']"}),
            'wikipedia_revision_id': ('django.db.models.fields.BigIntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'hdabo.timeperiod': {
            'Meta': {'unique_together': "(('label', 'school_period'),)", 'object_name': 'TimePeriod'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'label': ('django.db.models.fields.CharField', [], {'max_length': '512'}),
            'school_period': ('django.db.models.fields.IntegerField', [], {})
        }
    }

    complete_apps = ['hdabo']
