# -*- coding: utf-8 -*-
'''
@author: raphv
'''
from django.core.management.base import BaseCommand, CommandError
import django.utils.simplejson as json
from SPARQLWrapper import SPARQLWrapper, JSON
from hdalab.models import InseeCoords
import csv
import re
import sys

class Command(BaseCommand):
    '''
    Command to export tags
    '''
    args = '<path_to_csv_file>'
    options = ''
    help = """Imports Insee codes and geographic coordinates from a csv file"""
        
    def handle(self, *args, **options):

        if len(args) == 0 or not args[0]:
            raise CommandError("Give a CSV File to import")
        
        filename = args[0]
        
        csvfile = open(filename, "rb")
        dialect = csv.Sniffer().sniff(csvfile.read(1024))
        csvfile.seek(0)
        reader = csv.reader(csvfile, dialect)
        fieldstoget = [ 'ville', 'insee', 'latitude', 'longitude' ]
        
        for i,line in enumerate(reader):
            if i == 0:
                fields = {}
                minlength = 0
                for j,field in enumerate(line):
                    for fieldname in fieldstoget:
                        if re.search('(?i)%s' % fieldname, field):
                            fields[fieldname] = j
                            minlength = max(j,minlength)
            else:
                if len(line) > minlength:
                    rawdata = {k: line[v].strip() for k,v in fields.iteritems()}
                    #print "Processing line %d" % i
                    #print rawdata
                    try:
                        latitude = float(rawdata['latitude'].replace(',','.'))
                        longitude = float(rawdata['longitude'].replace(',','.')) if rawdata['longitude'] != '-' else 0
                        insee = int(rawdata['insee'])
                        ville = unicode(rawdata['ville'], 'iso-8859-1')
                        
                        InseeCoords.objects.get_or_create(insee=insee, city_name=ville, latitude=latitude, longitude=longitude)
                        
                    except:
                        print line, "Error :", sys.exc_info()[1]
        
        csvfile.close()