function polygon_to_gmap(polycoords, dbpedia_uri) {
    var _opts =  {
        strokeColor: "#000000",
        strokeWeight: .5,
        fillColor: "#7070a0",
        fillOpacity: .3
    }
    _opts.paths = polycoords.map(function(path) {
        return path.map(function(coord) {
            return new google.maps.LatLng(coord[1], coord[0]);
        });
    });
    var _polygon = new google.maps.Polygon(_opts);
    _polygon.setMap(gomNs.map);
    google.maps.event.addListener(_polygon, 'click', function(a,b) {
        addFilter('country', dbpedia_uri);
    })
    return _polygon;
}

function showCountriesGmap(geoJson) {
    gomNs.countries = {};
    _(geoJson.features).each(function(feature) {
        var _el = { "properties" : feature.properties };
        if (feature.id == 'ATA') {
            _el.gPolygons = [];
        } else {
            switch(feature.geometry.type) {
                case('Polygon'):
                    _el.gPolygons = [ polygon_to_gmap(feature.geometry.coordinates, feature.properties.dbpedia_uri) ];
                break;
                case('MultiPolygon'):
                    _el.gPolygons = feature.geometry.coordinates.map(function(polygon) {
                        return polygon_to_gmap(polygon, feature.properties.dbpedia_uri);
                    })
                break;
            }
        }
        gomNs.countries[feature.properties.dbpedia_uri] = _el;
    });
}

function showCountriesLeaflet(geoJson) {
    gomNs.countries = {};
    var gJ = new L.GeoJSON();
    gJ.on('featureparse', function(_f) {
        var isocode = _f.id;
        _f.layer.setStyle({
            color: "#000000",
            weight: .5,
            fillColor: "#7070a0",
            fillOpacity: .3
        });
        _f.layer.on('click', function() {
            addFilter('country', _f.properties.dbpedia_uri);
        });
        gomNs.countries[_f.properties.dbpedia_uri] = {
            "properties" : _f.properties,
            "layer" : _f.layer
        }
    });
    gJ.addGeoJSON(geoJson);
    gomNs.map.addLayer(gJ);
}
