/* Saves the Full JSON once */

Rkns.jsonIOSaveOnClick = function(_renkan, _opts) {
    var _proj = _renkan.project,
    _saveWarn = false,
    _onLeave = function() {
        return "Project not saved";
    },
    canRemoveChangeShape = false,
    changeShapeRemoved = false;
    if (typeof _opts.http_method === "undefined") {
        _opts.http_method = 'POST';
    }
    var _load = function() {
        var getdata = {},
        rx = /id=([^&#?=]+)/,
        matches = document.location.hash.match(rx);
        if (matches) {
            getdata.id = matches[1];
        }
        Rkns.$.ajax({
            url: _opts.url,
            data: getdata,
            beforeSend: function(){
                _proj.set({loading_status:true});
            },
            success: function(_data) {
                _renkan.dataloader.load(_data);
                if (typeof(_data.bins) != 'undefined'){
                    _renkan.tabs.push(new Rkns[_data.bins.type].Bin(_renkan, _data.bins));
                    delete _data.bins;
                }
                _proj.set(_data, {validate: true});
                _proj.set({loading_status:false});
                _proj.set({saveStatus:0});
                _renkan.renderer.fixSize(true);

                if(_opts.user_authenticated==true){
                    _renkan.setCurrentUser(_opts.user_id, _opts.user_name);
                }
                canRemoveChangeShape = true;
                _saveWarn = false;
                $(window).off("beforeunload", _onLeave);
            }
        });
    };
    var _save = function() {
        _proj.set("saved_at", new Date());
        var _data = _proj.toJSON();
        Rkns.$.ajax({
            type: _opts.http_method,
            url: _opts.url,
            contentType: "application/json",
            data: JSON.stringify(_data),
            success: function(data, textStatus, jqXHR) {
                $(window).off("beforeunload", _onLeave);
                _saveWarn = false;
                _proj.set({saveStatus:0});

                if(data.substr(0,6)=="rk_id="){
                    _opts.url = _opts.url.split("?")[0] + "?" + data;
                }
            }
        });
    };
    var _changeDispositionDisable = function() {
        if(canRemoveChangeShape && !changeShapeRemoved){
            $(".renkan_help ul").addClass("disable");
            $(".renkan_help ul li ul").remove();
            changeShapeRemoved = true;
        }
    }
    var _checkLeave = function() {
        _proj.set({saveStatus:1});

        var title = _proj.get("title");
        if (title && _proj.get("nodes").length) {
            $(".Rk-Save-Button").removeClass("disabled");
        } else {
            $(".Rk-Save-Button").addClass("disabled");
        }
        if (title) {
            $(".Rk-PadTitle").css("border-color","#333333");
        }
        if (!_saveWarn) {
            _saveWarn = true;
            $(window).on("beforeunload", _onLeave);
        }
    };
    _load();
    
    var modelChanged = function(_model) {
        if(!(_model.changedAttributes.length == 1 && _model.hasChanged('saveStatus'))) {
            _checkLeave();
            _changeDispositionDisable()
        }
    };
    
    _proj.on("add:nodes add:edges add:views", function(_model) {
        _model.on("change remove", modelChanged); 
    });
    _proj.on("add:nodes add:edges add:views change", modelChanged);

    _proj.on("add:users", function(){
        _checkLeave();
    });
    _renkan.renderer.save = function() {
        if(_opts.user_authenticated==true){
            if ($(".Rk-Save-Button").hasClass("disabled")) {
                if (!_proj.get("title")) {
                    $(".Rk-PadTitle").css("border-color","#ff0000");
                }
            } else {
                _save();
            }
        }
        else{
            dialog.dialog( "open" );
        }
    };
};
