# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import hdalab.fields
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        ('hdabo', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('renkanmanager', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('dbpedia_uri', models.URLField(unique=True, max_length=255, db_index=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='DatasheetExtras',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('datasheet', models.OneToOneField(related_name='extras', to='hdabo.Datasheet')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='DbpediaFields',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('dbpedia_uri', models.URLField(max_length=2048, db_index=True)),
                ('abstract', models.TextField(null=True, blank=True)),
                ('thumbnail', models.URLField(max_length=2048, null=True, blank=True)),
                ('label', models.CharField(max_length=2048, null=True, blank=True)),
                ('tag', hdalab.fields.OneToOneField(related_name='dbpedia_fields', to='hdabo.Tag', related_default=b'lambda:')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='DbpediaFieldsTranslation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('language_code', models.CharField(max_length=15, db_index=True)),
                ('label', models.CharField(max_length=2048, blank=True)),
                ('abstract', models.TextField(null=True, blank=True)),
                ('is_label_translated', models.BooleanField(default=True)),
                ('is_abstract_translated', models.BooleanField(default=True)),
                ('master', models.ForeignKey(related_name='translations', to='hdalab.DbpediaFields')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='GeoInclusion',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('country', models.ForeignKey(related_name='includes', to='hdalab.Country')),
                ('tag', models.OneToOneField(related_name='locatedin', to='hdabo.Tag')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='HdalabRenkan',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('state', models.IntegerField(default=1, choices=[(1, b'edition'), (2, b'moderated'), (3, b'published'), (4, b'rejected')])),
                ('favorite', models.BooleanField(default=False)),
                ('renkan', models.ForeignKey(to='renkanmanager.Renkan')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='HdalabRenkanStateTransition',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('from_state', models.IntegerField(default=1, choices=[(1, b'edition'), (2, b'moderated'), (3, b'published'), (4, b'rejected')])),
                ('to_state', models.IntegerField(default=1, choices=[(1, b'edition'), (2, b'moderated'), (3, b'published'), (4, b'rejected')])),
                ('ts', models.DateTimeField(auto_now_add=True)),
                ('message', models.TextField(null=True, blank=True)),
                ('author', models.ForeignKey(to=settings.AUTH_USER_MODEL)),
                ('renkan', models.ForeignKey(related_name='states', to='hdalab.HdalabRenkan')),
            ],
            options={
                'ordering': ['-ts'],
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='HdaSession',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('sessionid', models.CharField(unique=True, max_length=36, db_index=True)),
                ('data', models.TextField(null=True, blank=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='InfoboxParameter',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('param_name', models.CharField(max_length=2048)),
                ('param_value', models.TextField(null=True, blank=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='InseeCoords',
            fields=[
                ('insee', models.IntegerField(serialize=False, primary_key=True)),
                ('city_name', models.CharField(max_length=255)),
                ('latitude', models.FloatField()),
                ('longitude', models.FloatField()),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='TagInfobox',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=2048)),
                ('source', models.TextField(null=True, blank=True)),
                ('revision_id', models.BigIntegerField(null=True, blank=True)),
                ('tag', models.ForeignKey(related_name='infoboxes', to='hdabo.Tag')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='TagLinks',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('object', models.ForeignKey(related_name='taglinks_objects', to='hdabo.Tag')),
                ('subject', models.ForeignKey(related_name='taglinks_subjects', to='hdabo.Tag')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='TagWpCategory',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('hidden', models.BooleanField(default=False)),
                ('tag', models.ForeignKey(related_name='wp_categories', to='hdabo.Tag')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='TagYears',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('start_year', models.IntegerField(db_index=True)),
                ('end_year', models.IntegerField(db_index=True)),
                ('tag', models.ForeignKey(related_name='years', to='hdabo.Tag', unique=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='WpCategory',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('label', models.CharField(unique=True, max_length=2048)),
            ],
            options={
                'verbose_name_plural': 'WpCategories',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='WpCategoryInclusion',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('child_category', models.ForeignKey(related_name='parent_categories', to='hdalab.WpCategory')),
                ('parent_category', models.ForeignKey(related_name='child_categories', to='hdalab.WpCategory')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.AlterUniqueTogether(
            name='wpcategoryinclusion',
            unique_together=set([('parent_category', 'child_category')]),
        ),
        migrations.AddField(
            model_name='tagwpcategory',
            name='wp_category',
            field=models.ForeignKey(related_name='tags', to='hdalab.WpCategory'),
            preserve_default=True,
        ),
        migrations.AlterUniqueTogether(
            name='tagwpcategory',
            unique_together=set([('tag', 'wp_category', 'hidden')]),
        ),
        migrations.AlterUniqueTogether(
            name='taginfobox',
            unique_together=set([('tag', 'name', 'revision_id')]),
        ),
        migrations.AddField(
            model_name='infoboxparameter',
            name='tag_infobox',
            field=models.ForeignKey(to='hdalab.TagInfobox'),
            preserve_default=True,
        ),
        migrations.AlterUniqueTogether(
            name='infoboxparameter',
            unique_together=set([('tag_infobox', 'param_name')]),
        ),
        migrations.AlterUniqueTogether(
            name='dbpediafieldstranslation',
            unique_together=set([('master', 'language_code')]),
        ),
        migrations.AddField(
            model_name='datasheetextras',
            name='insee',
            field=models.ForeignKey(blank=True, to='hdalab.InseeCoords', null=True),
            preserve_default=True,
        ),
    ]
