// from http://stackoverflow.com/a/7031800

$.fn.reveal = function() {
    var args = Array.prototype.slice.call(arguments);
    return this.each(function(){
        var img = $(this),
            src = img.data("src");
        src && img.attr("src") !== src && img.attr("src", src).load(function(){
            img[args[0]||"show"].apply(img, args.splice(1));
        });
    });
};


function countContentsAndThemes(_data) {
    _data.counts = {
        contents: (typeof _data.contents == "object" && typeof _data.contents.slice == "function" ? _data.contents.length : 0),
        themes: (typeof _data.themes == "object" && typeof _data.themes.slice == "function" ? _data.themes.length : 0)
    }
    if (typeof _data.themes == "object" && typeof _data.themes.slice == "function") {
        for (var _i = 0; _i < _data.themes.length; _i++) {
            countContentsAndThemes(_data.themes[_i]);
            var _subres = _data.themes[_i].counts;
            _data.counts.contents += _subres.contents;
            _data.counts.themes += _subres.themes;
        }
    }
}

function renderTemplate(_data, _level, _scale, _maxlevel) {
    _data.isfolded = _level >= _maxlevel;
    _.each(_data.tags, function(_tag) {
        _.each(_tag.contents, function(_content, _key) {
            _content.trimmed_description = _content.description.trim().replace(/(\n|\r|\r\n)/mg,' ').replace(/(^.{150,200})[\s].+$/m,'$1&hellip;');
            _content.hidden = (_key >= 5);
        });
        _tag.show_more = _tag.contents && _tag.contents.length > 5 ? _tag.contents.length - 5 : 0;
    });
    _.each(_data.contents, function(_content, _key) {
        _content.trimmed_description = _content.description.trim().replace(/(\n|\r|\r\n)/mg,' ').replace(/(^.{150,200})[\s].+$/m,'$1&hellip;');
        _content.hidden = (_key >= 5);
    });
    _data.show_more = _data.contents && _data.contents.length > 5 ? _data.contents.length - 5 : 0;
    _data.font_size = (10+Math.log(_data.counts.contents)*_scale);
    var _dsurl = endpoints.datasheet.replace(/ID$/,'');
    var _prefix = '<li class="themeli{{#isfolded}} folded{{/isfolded}}"><p class="theme"><span style="font-size: {{font_size}}px">{{label}}</span> &mdash; {{#counts.themes}}{{counts.themes}} thème(s){{#counts.contents}}, {{/counts.contents}}{{/counts.themes}}{{#counts.contents}}{{counts.contents}} notice(s){{/counts.contents}}</p><ul>',
        _suffix = '{{#contents}}<li class="content{{#hidden}} hidden{{/hidden}}" id="content_{{id}}"><p class="title score_{{score}}"><a href="'
            + _dsurl
            + '{{hda_id}}">{{title}}</a></p><div class="foldedcontent"><div class="img-container"><img data-src="http://www.histoiredesarts.culture.fr/images/pf/{{hda_id}}.jpg" />'
            + '</div><p class="description">Source: <a href="{{organization_url}}" target="_blank">{{organization}}</a><br /><a href="'
            + _dsurl
            + '{{hda_id}}" class="content">{{trimmed_description}}</a></p></div></li>{{/contents}}{{#show_more}}<li class="show_more">Plus de contenus (<span class="show_more_count">{{show_more}}</span>)&hellip;</li>{{/show_more}}</ul></li>',
        _html = Mustache.to_html(_prefix, _data);
    if (typeof _data.themes == "object" && typeof _data.themes.slice == "function") {
        for (var _i = 0; _i < _data.themes.length; _i++) {
            _html += renderTemplate(_data.themes[_i], _level + 1, _scale, _maxlevel);
        }
    }
    _html += Mustache.to_html(_suffix, _data);
    return _html;
}

function renderData(_selector, _data, _maxlevel) {
    countContentsAndThemes(_data);
    var _scale = 8 / Math.max(1,Math.log(_data.counts.contents));
    _selector.html(renderTemplate(_data, 0, _scale, _maxlevel));
    _selector.find("p.theme").click(function() {
        $(this).parent().toggleClass("folded")
        return false;
    });
    _selector.find("li.content").mouseenter(function() {
        $(this).find(".foldedcontent")
        .dequeue()
        .animate({
            height: 5 + $(this).find("p.description").outerHeight()
        },
        500);
        $(this).find(".img-container img").reveal("fadeIn", 500);
    }).mouseleave(function() {
        $(this).find(".foldedcontent")
        .dequeue()
        .animate({
            height: "0"
        },
        500);
    });
    _selector.find(".show_more").click(function() {
        $(this).siblings(".hidden:lt(5)").removeClass("hidden");
        var _l = $(this).siblings(".hidden").length;
        $(this).find(".show_more_count").html(_l);
        if (!_l) {
            $(this).detach();
        }
    });
}
