# set base image (host OS)
FROM zenika/alpine-chrome:with-puppeteer as base

USER root

ENV LANG=C.UTF-8
ENV PYTHONIOENCODING=UTF-8
ENV PYTHON_VERSION=2.7.18
RUN apk add --no-cache ca-certificates
RUN \
  /bin/sh -c set -ex && \
  apk add --no-cache --virtual .fetch-deps gnupg tar xz && \
  wget -O python.tar.xz "https://www.python.org/ftp/python/${PYTHON_VERSION%%[a-z]*}/Python-$PYTHON_VERSION.tar.xz" && \
  mkdir -p /usr/src/python && \
  tar -xJC /usr/src/python --strip-components=1 -f python.tar.xz && \
  rm python.tar.xz && \
  apk add --no-cache --virtual .build-deps bzip2-dev coreutils dpkg-dev dpkg expat-dev findutils gcc gdbm-dev libc-dev libffi-dev libnsl-dev libtirpc-dev linux-headers make ncurses-dev openssl-dev pax-utils readline-dev sqlite-dev tcl-dev tk tk-dev zlib-dev && \
  apk del .fetch-deps && \
  cd /usr/src/python && \
  gnuArch="$(dpkg-architecture --query DEB_BUILD_GNU_TYPE)" && \
  ./configure --build="$gnuArch" --enable-optimizations --enable-option-checking=fatal --enable-shared --enable-unicode=ucs4 --with-system-expat --with-system-ffi && \
  make -j "$(nproc)" EXTRA_CFLAGS="-DTHREAD_STACK_SIZE=0x100000" PROFILE_TASK='-m test.regrtest --pgo test_array test_base64 test_binascii test_binhex test_binop test_bytes test_c_locale_coercion test_class test_cmath test_codecs test_compile test_complex test_csv test_decimal test_dict test_float test_fstring test_hashlib test_io test_iter test_json test_long test_math test_memoryview test_pickle test_re test_set test_slice test_struct test_threading test_time test_traceback test_unicode ' && \
  make install && \
  find /usr/local -type f -executable -not \( -name '*tkinter*' \) -exec scanelf --needed --nobanner --format '%n#p' '{}' ';' | tr ',' '\n' | sort -u | awk 'system("[ -e /usr/local/lib/" $1 " ]") == 0 { next } { print "so:" $1 }' | xargs -rt apk add --no-cache --virtual .python-rundeps && \
  apk del .build-deps && \
  find /usr/local -depth \( \( -type d -a \( -name test -o -name tests -o -name idle_test \) \) -o \( -type f -a \( -name '*.pyc' -o -name '*.pyo' \) \) \) -exec rm -rf '{}' + && \
  rm -rf /usr/src/python && \
  python2 --version


ENV PYTHON_PIP_VERSION=20.0.2
ENV PYTHON_GET_PIP_URL=https://github.com/pypa/get-pip/raw/d59197a3c169cef378a22428a3fa99d33e080a5d/get-pip.py

RUN \
  wget -O get-pip.py "$PYTHON_GET_PIP_URL"; python get-pip.py --disable-pip-version-check --no-cache-dir "pip==$PYTHON_PIP_VERSION" ; pip --version; find /usr/local -depth \( \( -type d -a \( -name test -o -name tests -o -name idle_test \) \) -o \( -type f -a \( -name '*.pyc' -o -name '*.pyo' \) \) \) -exec rm -rf '{}' +; rm -f get-pip.py

FROM base as builder

ENV VIRTUALENV=/opt/venv

# set the working directory in the container
WORKDIR /code

RUN \
    pip install virtualenv && \
    virtualenv $VIRTUALENV

ENV PATH="$VIRTUALENV/bin:$PATH"

# copy the dependencies file to the working directory
COPY docker/server/requirements.txt .


RUN \
 apk add --no-cache postgresql-client postgresql-libs libxml2 libxslt libmemcached curl tar && \
 apk add --no-cache --virtual .build-deps git gcc musl-dev postgresql-dev libxml2-dev libxslt-dev linux-headers libmemcached-dev libffi-dev libgcc openssl-dev curl jpeg-dev zlib-dev freetype-dev lcms2-dev openjpeg-dev tiff-dev tk-dev tcl-dev && \
 pip install -r requirements.txt && \
 curl -L https://www.iri.centrepompidou.fr/dev/hg/renkan/archive/V00.13.04.tar.gz | tar zxvf - --strip-components=4 renkan-V00.13.04/server/python/django/renkanmanager 


FROM base 

COPY --from=builder /opt/venv /opt/venv
COPY --from=builder /code/renkanmanager /code/renkanmanager
COPY src/ /code/
 
 
ENV BASEDIR="/code"
ENV PATH="/opt/venv/bin:$BASEDIR:$PATH"
 
WORKDIR $BASEDIR
 
RUN \
  apk add --no-cache postgresql-client postgresql-libs libxml2 libxslt bash libmemcached py-pathlib2 jpeg-dev zlib-dev freetype-dev lcms2-dev openjpeg-dev tiff-dev tk-dev tcl-dev && \
  mkdir -p /static
 
COPY docker/server/config.py ./hdalab/
  
ENV PYTHONPATH "/code/"
ENV DJANGO_SETTINGS_MODULE hdalab.settings
ENV DEBUG "False"
ENV DATABASE_URL ""
ENV ES_HOST "es"
ENV DJANGO_SECRET ""
ENV ADMIN_EMAIL ""
ENV BROKER_PASSWORD ""

COPY --from=base /usr/src/app/node_modules /code/node_modules
USER chrome
#ENTRYPOINT ["chromium-browser", "--headless"]
 
 