#!/usr/bin/env bash
pushd () {
    command pushd "$@" > /dev/null
}

popd () {
    command popd "$@" > /dev/null
}


SCRIPTPATH="$( cd "$(dirname "$0")" ; pwd -P )"

pushd $SCRIPTPATH

echo "Building hdalab"
pushd ../src

HDALAB_ARCH_BASENAME=`python setup.py --fullname`
python setup.py sdist
popd

rm -fr hdalab/dist/*
mkdir -p hdalab/dist/data
mkdir -p hdalab/dist/renkan

echo "building renkanmanager"
echo "-> downloading renkan"
curl "https://www.iri.centrepompidou.fr/dev/hg/renkan/archive/tip.tar.gz" -o hdalab/dist/renkan/renkan.tar.gz
pushd hdalab/dist/renkan
tar zxf renkan.tar.gz --strip 1
popd
echo "-> building renkan"
pushd hdalab/dist/renkan/server/python/django

RENKANMANAGER_ARCH_BASENAME=`python setup.py --fullname`
python setup.py sdist
popd
cp "hdalab/dist/renkan/server/python/django/dist/$RENKANMANAGER_ARCH_BASENAME.tar.gz" hdalab/dist/renkanmanager.tar.gz
echo "-> cleaning renkan"
rm -fr hdalab/dist/renkan

cp ../virtualenv/web/res/base_requirements.txt hdalab/dist/
cp "../src/dist/$HDALAB_ARCH_BASENAME.tar.gz" hdalab/dist/hdalab.tar.gz
cp ../data/* hdalab/dist/data/

popd
