from django.conf import settings
from django.contrib.auth.decorators import login_required
from django.core.urlresolvers import reverse
from django.db.models import Q
from django.forms.models import model_to_dict
from django.forms.util import ErrorList
from django.http import (HttpResponse, HttpResponseRedirect,
    HttpResponseForbidden, HttpResponseServerError)
from django.shortcuts import (render_to_response, get_object_or_404,
    get_list_or_404)
from django.template import RequestContext
from models import Organisation, Datasheet


#@login_required
def home(request):
    
    # Get all organisations
    org_list = Organisation.objects.all()
    
    return render_to_response("partial/organisation_list.html",
                              {'organisations':org_list},
                              context_instance=RequestContext(request))


#@login_required
def list_for_orga(request, orga_id=None, valid=None, start_index=None):
    
    orga = Organisation.objects.get(id=orga_id)
    orga_name = orga.name
    # If valid = 0, we search unvalidated sheets
    # If valid = 1, we search validated sheets
    # If valid = 2, we search AND DISPLAY all sheets
    all_datasheets = Datasheet.objects.filter(organisation=orga)
    nb_sheets = len(all_datasheets)
    
    if start_index :
        try:
            start_index = int(start_index)
        except :
            start_index = 0
    else :
        start_index = 0
    
    if valid == "1" :
        # We count all the validated sheets
        datasheets = all_datasheets.filter(validated=True)
        nb_sheets = len(datasheets)
        # And select the current one
        datasheets = [datasheets[start_index]]
    elif valid != "2":
        # We count all the validated sheets
        datasheets = all_datasheets.filter(validated=False)
        nb_sheets = len(datasheets)
        # And select the current one
        datasheets = [datasheets[start_index]]
    else :
        datasheets = all_datasheets
    
    displayed_index = start_index + 1;
    prev_index = max(start_index - 1, 0);
    next_index = min(nb_sheets - 1, start_index + 1);
    last_index = max(nb_sheets - 1, 0);
    
    return render_to_response("partial/list_for_orga.html",
                              {'datasheets':datasheets, 'orga_name':orga_name,
                               'nb_sheets':nb_sheets,'orga_id':orga_id,
                               'prev_index':prev_index, 'next_index':next_index, 'last_index':last_index,
                               'start_index':start_index, 'displayed_index':displayed_index, 'valid':valid},
                              context_instance=RequestContext(request))

