<?php
    $basechars = '23456789abcdefghjkmnpqrstuvwxyz';
    $base = strlen($basechars);
    
    function my_encode($int) {
        global $base, $basechars;
        $nb = $int;
        $res = '';
        while($nb > 0 or strlen($res) == 0) {
            $mod = $nb % $base;
            $res = $basechars[$mod].$res;
            $nb = ($nb - $mod) / $base;
        }
        return $res;
    }
    
    function my_decode($str) {
        global $base, $basechars;
        $s = strtolower($str);
        $m = 1;
        $res = 0;
        for ($i = strlen($s)-1; $i >= 0; $i--) {
            $res += $m * strpos($basechars, $s[$i]);
            $m *= $base;
        }
        return $res;
    };
    
    require('connect.inc.php');
    
    session_start();
    
    $data = isset($_REQUEST['data']) ? $_REQUEST['data'] : false;
    $insdata = pg_escape_string($data ? $data : '{}');
    
    if (isset($_REQUEST['sessionid'])) {
        $_SESSION['sessionid'] = $_REQUEST['sessionid'];
    }
    
    if (isset($_REQUEST['sessionkey'])) {
        $_SESSION['sessionkey'] = $_REQUEST['sessionkey'];
    }
    
    if (isset($_SESSION['sessionid'])) {
        $sidnum = my_decode($_SESSION['sessionid']);
        $rq = pg_query("SELECT editkey FROM hdaviz_sessions WHERE id = $sidnum");
        if ($ligne = pg_fetch_row($rq)) {
            if (isset($_SESSION['sessionkey'])) {
                $keynum = my_decode($_SESSION['sessionkey']);
                if ($keynum == $ligne[0]) {
                    $write = true;
                } else {
                    $write = false;
                    unset($_SESSION['sessionkey']);
                }
            } else {
                $keynum = false;
                $write = false;
            }
        } else {
            unset($_SESSION['sessionid']);
        }
    }
    
    if (!isset($_SESSION['sessionid'])) {
        do {
            $sidnum = mt_rand(1000, 100000000);
            $rq = pg_query("SELECT COUNT(*) FROM hdaviz_sessions WHERE id=$sidnum");
            $l = pg_fetch_row($rq);
            $nb = $l[0];
            pg_free_result($rq);
        } while ($nb > 0);
        $keynum = mt_rand(104, 100000001);
        $rq = pg_query("INSERT INTO hdaviz_sessions (id, editkey, data) VALUES ($sidnum, $keynum, '{}')");
        $write = true;
        $_SESSION['sessionid'] = my_encode($sidnum);
        $_SESSION['sessionkey'] = my_encode($keynum);
    }
    
    if ($write and $data) {
        pg_query("UPDATE hdaviz_sessions SET data='$insdata' WHERE id=$sidnum AND editkey=$keynum");
    } else {
        $rq = pg_query("SELECT data FROM hdaviz_sessions WHERE id=$sidnum");
        $l = pg_fetch_row($rq);
        $data = $l[0];
        pg_free_result($rq);
    }
    
    $resobj = array("data" => $data, "write_allowed" => $write, "sessionid" => $_SESSION['sessionid']);
    if ($write) {
        $resobj["sessionkey"] = $_SESSION['sessionkey'];
    }
    

echo json_encode($resobj);
?>