# -*- coding: utf-8 -*-
'''
Created on Jul 01, 2014

@author: tc
'''

from hdalab.models.renkan import HdalabRenkan
from hdabo.views import Folders, AddOrUpdateFolder, DeleteFolder
from hdalab.views.profile import BaseRenkanList

import logging
logger = logging.getLogger(__name__)


class ManageRenkans(BaseRenkanList):
    template_name = "editorial/manage_renkans.html"
    
    def get_context_data(self, **kwargs):
        return self.update_context(super(ManageRenkans, self).get_context_data(**kwargs), HdalabRenkan.objects.exclude(state=HdalabRenkan.EDITION).select_related("renkan", "renkan__owner"))


class HdalabFolders(Folders):
    template_name = "editorial/folders.html"



class HdalabAddOrUpdateFolder(AddOrUpdateFolder):
    template_name = "editorial/add_or_update_folder.html"
    redirect_view = 'hdalab_folders'



class HdalabDeleteFolder(DeleteFolder):
    redirect_view = 'hdalab_folders'