'''
Created on Jul 17, 2014

@author: tc
'''
from django.db import models
from django.utils.translation import ugettext as _
from renkanmanager.models import Renkan


class HdalabRenkan(models.Model):
    
    EDITION = 1
    MODERATED = 2
    PUBLISHED = 3
    REJECTED = 4
      
    STATE_CHOICES = (
    (EDITION, 'edition'),
    (MODERATED, 'moderated'),
    (PUBLISHED, 'published'),
    (REJECTED, 'rejected'),
    )
    
    STATE_CHOICES_DICT = {
        EDITION: _('edition_state'),
        MODERATED: _('moderated_state'),
        PUBLISHED: _('published_state'),
        REJECTED: _('rejected_state')
    }
    
    renkan = models.ForeignKey(Renkan, blank=False, null=False)
    state = models.IntegerField(choices=STATE_CHOICES, default=1)
    
    class Meta:
        app_label = 'hdalab'
