# set base image (host OS)
FROM docker.io/python:2.7-alpine as builder

ENV VIRTUALENV=/opt/venv

# set the working directory in the container
WORKDIR /code

RUN \
    pip install virtualenv && \
    virtualenv $VIRTUALENV

ENV PATH="$VIRTUALENV/bin:$PATH"

# copy the dependencies file to the working directory
COPY docker/server/requirements.txt .


RUN \
 apk add --no-cache postgresql-client postgresql-libs libxml2 libxslt libmemcached curl tar && \
 apk add --no-cache --virtual .build-deps git gcc musl-dev postgresql-dev libxml2-dev libxslt-dev linux-headers libmemcached-dev libffi-dev libgcc openssl-dev curl jpeg-dev zlib-dev freetype-dev lcms2-dev openjpeg-dev tiff-dev tk-dev tcl-dev && \
 pip install -r requirements.txt && \
 curl -L https://www.iri.centrepompidou.fr/dev/hg/renkan/archive/V00.13.04.tar.gz | tar zxvf - --strip-components=4 renkan-V00.13.04/server/python/django/renkanmanager 


FROM docker.io/python:2.7-alpine 

COPY --from=builder /opt/venv /opt/venv
COPY --from=builder /code/renkanmanager /code/renkanmanager
COPY src/ /code/


ENV BASEDIR="/code"
ENV PATH="/opt/venv/bin:$BASEDIR:$PATH"

WORKDIR $BASEDIR

RUN \
 apk add --no-cache postgresql-client postgresql-libs libxml2 libxslt bash libmemcached py-pathlib2 jpeg-dev zlib-dev freetype-dev lcms2-dev openjpeg-dev tiff-dev tk-dev tcl-dev && \
 mkdir -p /static


COPY docker/server/config.py ./hdalab/

COPY docker/server/hdalab.yml .
COPY --chmod=0755 docker/server/entrypoint.sh /

ENV PYTHONPATH "/code/"
ENV DJANGO_SETTINGS_MODULE hdalab.settings
ENV DEBUG "False"
ENV DATABASE_URL ""
ENV ES_HOST "es"
ENV DJANGO_SECRET ""
ENV ADMIN_EMAIL ""
ENV BROKER_PASSWORD ""


EXPOSE 8000

ENTRYPOINT ["/entrypoint.sh"]

# command to run on container start
CMD [ "/opt/venv/bin/uwsgi", "--yaml", "/code/hdalab.yml"]