# -*- coding: utf-8 -*-
'''
@author: raphv
'''
import csv
import re

from django.core.management.base import BaseCommand, CommandError

from hdabo.models import Datasheet
from hdalab.models import InseeCoords, DatasheetExtras


class Command(BaseCommand):
    '''
    Command to export tags
    '''
    args = '<path_to_csv_file>'
    options = ''
    help = """Imports HDA Lab INSEE codes from a csv file"""
        
    def handle(self, *args, **options):

        if len(args) == 0 or not args[0]:
            raise CommandError("Give a CSV File to import")
        
        filename = args[0]
        
        csvfile = open(filename, "rb")
        dialect = csv.Sniffer().sniff(csvfile.read(1024))
        csvfile.seek(0)
        reader = csv.reader(csvfile, dialect)
        fieldstoget = [ 'id', 'insee' ]
        
        
        for i,line in enumerate(reader):
            if i == 0:
                fields = {}
                minlength = 0
                for j,field in enumerate(line):
                    for fieldname in fieldstoget:
                        if re.search('(?i)%s' % fieldname, field):
                            fields[fieldname] = j
                            minlength = max(j,minlength)
            else:
                if len(line) > minlength:
                    rawdata = dict([(k,line[v].strip()) for k,v in fields.iteritems()])
                    # Traitement special pour la Corse
                    insee = int(re.sub('^2(A|B)','20',rawdata['insee']))
                        
                    hda_id = int(rawdata['id'])
                    
                    try:
                        datasheet = Datasheet.objects.get(hda_id=hda_id)
                    except Datasheet.DoesNotExist:
                        #print "Datasheet for id %d does not exist" % hda_id
                        datasheet = None
                    try:
                        inseecoord = InseeCoords.objects.get(insee=insee)
                    except InseeCoords.DoesNotExist:
                        print "INSEE entry for Insee Code %d does not exist" % insee
                        inseecoord = None
                    
                    if datasheet is not None and inseecoord is not None:
                        dsextra, created = DatasheetExtras.objects.get_or_create(datasheet=datasheet, defaults={'insee':inseecoord})
                        if not created:
                            dsextra.insee = inseecoord
                            dsextra.save()
        
        csvfile.close()