# -*- coding: utf-8 -*-
from django import forms
from django.db.models.query import QuerySet
from django.utils.translation import ugettext_lazy as _

from registration.forms import RegistrationFormUniqueEmail

class SortedMultipleChoiceField(forms.ModelMultipleChoiceField):
    def clean(self, value):
        queryset = super(SortedMultipleChoiceField, self).clean(value)
        if value is None or not isinstance(queryset, QuerySet):
            return queryset
        object_list = dict((
            (unicode(key), value)
            for key, value in queryset.in_bulk(value).iteritems()))
        return [object_list[unicode(pk)] for pk in value]

class HdaboRegistrationForm(RegistrationFormUniqueEmail):
    error_css_class = "registration-error"

    def __init__(self, *args, **kwargs):
        super(HdaboRegistrationForm, self).__init__(*args, **kwargs)
        self.fields['email'].help_text = _("email help text")
        self.fields['password2'].help_text = None
