# -*- coding: utf-8 -*-
from django.conf.urls import patterns, include, url
from django.views.generic import TemplateView
from hdalab.views.profile import ProfileHome, RenkanEdit, HdalabRenkanGetPut,\
    RenkanNew, RenkanPublicList, HdalabRenkanCopy, HdalabRenkanDelete,\
    HdalabRenkanModerate
from django.contrib.auth.decorators import login_required
from django.contrib.admin.views.decorators import staff_member_required
from hdalab.views.editorial import HdalabFolders, HdalabAddOrUpdateFolder,\
    HdalabDeleteFolder, ManageRenkans

# Uncomment the next two lines to enable the admin:
# from django.contrib import admin
# admin.autodiscover()

urlpatterns = patterns('',
    # Examples:
    # url(r'^$', 'hdalab.views.home', name='home'),
    # url(r'^hdalab/', include('hdalab.foo.urls')),

    # Uncomment the admin/doc line below to enable admin documentation:
    # url(r'^admin/doc/', include('django.contrib.admindocs.urls')),

    # Uncomment the next line to enable the admin:
    #url(r'^admin/', include(admin.site.urls)),
    
    url(r'^hdabo/', include('hdabo.urls')),
    url(r'^i18n/', include('django.conf.urls.i18n')),
    url('^jsi18n/?$', 'django.views.i18n.javascript_catalog', name='jsi18n.all'),
    url('^jsi18n/(?P<packages>\S+?)/$', 'django.views.i18n.javascript_catalog', {'domain':'djangojs'}, name='jsi18n'),
    
    url(r'^facettes/', TemplateView.as_view(template_name="facettes.html"), name='facettes'),
    url(r'^categories/', TemplateView.as_view(template_name="categories.html"), name='categories'),
    url(r'^thesaurus/', TemplateView.as_view(template_name="thesaurus.html"), name='thesaurus'),
    url(r'^$', TemplateView.as_view(template_name="index.html"), name='home'),
    
    url(r'^notice/(?P<hda_id>[\w-]+)$', 'hdalab.views.pages.datasheet', name='notice'),
    
    url(r'^renkan/new/$',login_required(RenkanNew.as_view()), name='renkan_new'),
    url(r'^renkan/edit/$', RenkanEdit.as_view(), name='renkan_edit'),
    url(r'^renkan/getput/$', HdalabRenkanGetPut.as_view(), name='renkan_get_put'),
    url(r'^renkan/view/$', TemplateView.as_view(template_name="renkan_view.html"), name='renkan_view'),
    url(r'^renkan/copy/(?P<rk_id>.*)$', login_required(HdalabRenkanCopy.as_view()), name='renkan_copy'),
    url(r'^renkan/delete/(?P<rk_id>.*)$', login_required(HdalabRenkanDelete.as_view()), name='renkan_delete'),
    url(r'^renkan/moderate/(?P<rk_id>.*)/(?P<state>.*)$', login_required(HdalabRenkanModerate.as_view()), name='renkan_moderate'),
    url(r'^profile/$', login_required(ProfileHome.as_view()), name='profile_home'),
    url(r'^renkan/public/$', RenkanPublicList.as_view(), name='renkan_public_list'),
    url(r'^ajaxlogin/$', "hdalab.views.profile.ajax_login", name='ajax_login'),
    url(r'^ajaxloginok/$', TemplateView.as_view(template_name="ajax_identification/ajax_login_ok.html"), name='ajax_login_ok'),
    url(r'^edito/$', staff_member_required(TemplateView.as_view(template_name="editorial/edito_home.html")), name='edito_home'),
    url(r'^edito/manage/$', staff_member_required(ManageRenkans.as_view()), name='manage_renkans'),
    url(r'^edito/folders/$', staff_member_required(HdalabFolders.as_view()), name='hdalab_folders'),
    url(r'^edito/folder/$', staff_member_required(HdalabAddOrUpdateFolder.as_view()), name='hdalab_add_or_update_folder'),
    url(r'^edito/folder/(?P<folder_pk>[\w-]+)$', staff_member_required(HdalabAddOrUpdateFolder.as_view()), name='hdalab_add_or_update_folder'),
    url(r'^edito/deletefolder/(?P<folder_pk>[\w-]+)$', staff_member_required(HdalabDeleteFolder.as_view()), name='hdalab_delete_folder'),

)

urlpatterns += patterns('hdalab.views.ajax',
    (r'^a/filter$', 'filter', {}, 'filter'),
    #(r'^a/sessioninfo$', 'sessioninfo', {}, 'session_info'),
    (r'^a/tagsearch$', 'tagsearch', {}, 'tag_search'),
    (r'^a/catsearch$', 'catsearch', {}, 'cat_search'),
    (r'^a/cattree$', 'cattree', {}, 'cat_tree'),
    (r'^a/filltree$', 'filltree', {}, 'fill_tree'),
)
