# -*- coding: utf-8 -*-
'''
Created on Feb 28, 2012

@author: ymh
'''
from django.core.management.base import BaseCommand
from django.core.management import call_command
from optparse import make_option
import os.path


class Command(BaseCommand):

    args = "[<path to the data folder>]"
    option_list = BaseCommand.option_list + (
        make_option('-c', '--categories',
            action='store_true',
            dest='categories',
            default=False,
            help='load categories in db'),
    )


    def handle(self, *args, **options):        
        
        if len(args) == 0:
            data_path = os.path.abspath(os.path.join(os.path.basename(__file__),'../../../../data'))
        else:
            data_path = args[0]
        
        call_command('migrate')
        if options.get('categories', False):
            call_command('query_wikipedia_category')
                
        call_command('query_dbpedia')
        call_command('fill_tag_years')
        call_command('query_geo_inclusion')
        call_command('import_insee_csv', os.path.join(data_path,'villes.csv'))
        call_command('import_insee_csv', os.path.join(data_path,'additional_cities.csv'))
        call_command('import_hda_insee_csv', os.path.join(data_path,'HDA_Insee.csv'))
        
        