from django.test import TestCase

from hdabo.models import Datasheet

class DatasheetTest(TestCase):
    fixtures = ['datasheet_ten']
    
    def setUp(self):
        self.datasheet_instance = Datasheet.objects.get(hda_id = '1608')
    
    def test_domain_text(self):
        domain_text = [s.strip() for s in self.datasheet_instance.domain_text.split(";")]
        domain_text.sort()
        self.assertEqual([u"Arts du quotidien", u"Arts du visuel"],domain_text)
