from django.conf.urls.defaults import patterns, include, url
from django.contrib import admin
from django.contrib.auth import urls as auth_url


# Uncomment the next two lines to enable the admin:
admin.autodiscover()

urlpatterns = patterns('',
    # Examples:
    # url(r'^$', 'hdabo.views.home', name='home'),
    # url(r'^hdabo/', include('hdabo.foo.urls')),

    # Uncomment the admin/doc line below to enable admin documentation:
    # url(r'^admin/doc/', include('django.contrib.admindocs.urls')),

    # Uncomment the next line to enable the admin:
    url(r'^accounts/', include(auth_url)),
    url(r'^logout/', 'django.contrib.auth.views.logout_then_login'),
    url(r'^admin/', include(admin.site.urls)),
    url(r'^search/', include('haystack.urls')),
    url(r'^$', 'hdabo.views.home', name='home'),
    url(r'^list/(?P<orga_id>[\w-]+)$', 'hdabo.views.list_for_orga', name='list_for_orga'),
    url(r'^list/(?P<orga_id>[\w-]+)/(?P<valid>[\w-]+)/$', 'hdabo.views.list_for_orga', name='list_for_orga'),
    url(r'^list/(?P<orga_id>[\w-]+)/(?P<valid>[\w-]+)/(?P<start_index>[\w-]+)/$', 'hdabo.views.list_for_orga', name='list_for_orga'),
    url(r'^list/(?P<orga_id>[\w-]+)/(?P<valid>[\w-]+)/(?P<start_index>[\w-]+)/(?P<length>[\w-]+)/$', 'hdabo.views.list_for_orga', name='list_for_orga'),
    url(r'^tagupdown$', 'hdabo.views.tag_up_down'),
    url(r'^removetagfromlist$', 'hdabo.views.remove_tag_from_list'),
    url(r'^modifytag$', 'hdabo.views.modify_tag'),
    url(r'^modifytagds$', 'hdabo.views.modify_tag_datasheet'),
    url(r'^resetwpinfo$', 'hdabo.views.reset_wikipedia_info'),
    url(r'^addtag$', 'hdabo.views.add_tag'),
    url(r'^removewplink$', 'hdabo.views.remove_wp_link'),
    url(r'^alltags$', 'hdabo.views.all_tags'),
    url(r'^alltags/(?P<num_page>[\w-]+)$', 'hdabo.views.all_tags'),
    url(r'^alltags/(?P<num_page>[\w-]+)/(?P<nb_by_page>[\w-]+)/$', 'hdabo.views.all_tags'),
    url(r'^alltags/(?P<num_page>[\w-]+)/(?P<nb_by_page>[\w-]+)/(?P<searched>.+)/$', 'hdabo.views.all_tags'),
    url(r'^validatedatasheet$', 'hdabo.views.validate_datasheet'),
    url(r'^validatedatasheet/(?P<ds_id>[\w-]+)$', 'hdabo.views.validate_datasheet'),
    url(r'^validatedatasheet/(?P<ds_id>[\w-]+)/(?P<valid>[\w-]+)/$', 'hdabo.views.validate_datasheet'),
    url(r'^updatetagalias$', 'hdabo.views.update_tag_alias'),
    url(r'^updatetagcategory$', 'hdabo.views.update_tag_category'),
)
