from django.conf import settings
from django.contrib.auth.decorators import login_required #@UnusedImport
from django.shortcuts import render_to_response
from django.template import RequestContext
from hdabo.wp_utils import query_wikipedia_title
from models import Organisation, Datasheet, TaggedSheet, Tag
from wikitools import wiki


#@login_required
def home(request):
    
    # Get all organisations
    orgas = Organisation.objects.all()
    # Count all validated, unvalidated sheets for each organisation
    org_list = []
    for orga in orgas :
        all_datasheets = Datasheet.objects.filter(organisation=orga)
        nb_all = len(all_datasheets)
        nb_val = len(all_datasheets.filter(validated=True))
        nb_unval = len(all_datasheets.filter(validated=False))
        org_list.append({'organisation':orga, 'nb_all':nb_all, 'nb_val':nb_val, 'nb_unval':nb_unval})
    
    
    return render_to_response("partial/organisation_list.html",
                              {'organisations':org_list},
                              context_instance=RequestContext(request))


#@login_required
def list_for_orga(request, orga_id=None, valid=None, start_index=None):
    
    orga = Organisation.objects.get(id=orga_id)
    orga_name = orga.name
    
    if start_index :
        try:
            start_index = int(start_index)
        except :
            start_index = 0
    else :
        start_index = 0
    
    # If valid = 0, we search unvalidated sheets
    # If valid = 1, we search validated sheets
    # If valid = 2, we search AND DISPLAY all sheets
    if valid == "1" :
        # We count all the validated sheets
        datasheets = Datasheet.objects.filter(organisation=orga).filter(validated=True)
        nb_sheets = len(datasheets)
        # And select the current one
        datasheets = [datasheets[start_index]]
    elif valid != "2":
        # We count all the validated sheets
        datasheets = Datasheet.objects.filter(organisation=orga).filter(validated=False)
        nb_sheets = len(datasheets)
        # And select the current one
        datasheets = [datasheets[start_index]]
    else :
        datasheets = Datasheet.objects.filter(organisation=orga)
        nb_sheets = len(datasheets)
    
    # We get the ORDERED tags if we display one sheet (case valid = 0 and 1)
    ordered_tags = None
    if valid != "2" :
        ordered_tags = TaggedSheet.objects.filter(datasheet=datasheets[0]).order_by('order')
    
    displayed_index = start_index + 1;
    prev_index = max(start_index - 1, 0);
    next_index = min(nb_sheets - 1, start_index + 1);
    last_index = max(nb_sheets - 1, 0);
    
    return render_to_response("partial/list_for_orga.html",
                              {'datasheets':datasheets, 'orga_name':orga_name,
                               'nb_sheets':nb_sheets, 'orga_id':orga_id, 'ordered_tags':ordered_tags,
                               'prev_index':prev_index, 'next_index':next_index, 'last_index':last_index,
                               'start_index':start_index, 'displayed_index':displayed_index, 'valid':valid},
                              context_instance=RequestContext(request))

#@login_required
def tag_up_down(request):
    ds_id = request.POST["datasheet_id"]
    #tag_id = request.POST["tag_id"]
    # tag_pos indicates the position (from 0) of the tag in the list. NB : it is different from the TagSheet.order in the database.
    tag_pos = int(request.POST["tag_pos"])
    # move can be "u" or "d", for up and down
    move = request.POST["move"]
    # First we get the datasheet's TaggedSheets
    ordered_tags = TaggedSheet.objects.filter(datasheet=Datasheet.objects.filter(id=ds_id)[0]).order_by('order')
    # We get the current TaggedSheet and its's order
    #ts = ordered_tags.filter(tag=Tag.objects.filter(id=tag_id))[0]
    ts = ordered_tags[tag_pos]
    tag_order = ts.order
    # We get the other TaggedSheet that will be moved
    if move == "u" :
        other_ts = ordered_tags[tag_pos - 1]
    elif move == "d" :
        other_ts = ordered_tags[tag_pos + 1]
    else :
        other_ts = None
    # We switch the orders
    if other_ts :
        ts.order = other_ts.order
        other_ts.order = tag_order
        ts.save()
        other_ts.save()
    
    return get_tag_table(request=request, ds_id=ds_id, valid=0)


#@login_required
def get_tag_table(request=None, ds_id=None, valid=None):
    
    ordered_tags = TaggedSheet.objects.filter(datasheet=Datasheet.objects.filter(id=ds_id)[0]).order_by('order')
    
    return render_to_response("partial/tag_table.html",
                              {'ordered_tags':ordered_tags, 'valid':valid},
                              context_instance=RequestContext(request))


#@login_required
def remove_tag_from_list(request=None):
    
    ds_id = request.POST["datasheet_id"]
    tag_id = request.POST["tag_id"]
    # First we get the datasheet's TaggedSheets
    ds_tags = TaggedSheet.objects.filter(datasheet=Datasheet.objects.filter(id=ds_id)[0])
    # We get the current TaggedSheet and we delete it
    ts = ds_tags.filter(tag=Tag.objects.filter(id=tag_id))[0]
    ts.delete()
    
    return get_tag_table(request=request, ds_id=ds_id, valid=0)


#@login_required
def validate_wp_link(request=None):
    
    ds_id = request.POST["datasheet_id"]
    tag_id = request.POST["tag_id"]
    if request.POST["activated"] != "false" :
        wp_activ = True
    else :
        wp_activ = False
    # First we get the tag object
    tag = Tag.objects.filter(id=tag_id)[0]
    tag.wikipedia_activated = wp_activ
    tag.save()
    
    return get_tag_table(request=request, ds_id=ds_id, valid=0)

#@login_required
def modify_tag(request):
    
    tag_id = request.POST["id"]
    tag_label = request.POST["value"]
    ds_id = request.POST["datasheet_id"]
    
    site = wiki.Wiki(settings.WIKIPEDIA_API_URL) #@UndefinedVariable
    
    new_label, status, url, pageid, response = query_wikipedia_title(site, tag_label) #@UnusedVariable
    
    tag = Tag.objects.get(id=tag_id)
    
    if new_label is not None:
        tag.label = new_label
    if status is not None:
        tag.url_status = status
    if url is not None:
        tag.wikipedia_url = url
        tag.wikipedia_activated = True
    if pageid is not None:
        tag.wikipedia_pageid = pageid
        
    tag.save()
    
    return get_tag_table(request=request, ds_id=ds_id, valid=0)
