﻿// -*- coding: utf-8 -*-
function init_tags_events()
{
    // Up and down management for tag table lines
    $(".up,.down").click(function(){
        tag_up_down(this);
    });
    // Remove tag for a datasheet's list
    $(".remove_tag_from_list").click(function(){
        if(confirm("Confirmez-vous la suppression du tag \"" + $(this).attr('alt') + "\" de la liste courante ?")){
            remove_tag_from_list(this);
        }
    });
    //activate_wp_cb
    $(".activate_wp_cb").click(function(e){
        new_checked = $(this).is(':checked');
        if(new_checked){
            question = "Confirmez-vous l'activation du lien Wikipédia pour le tag \"" + $(this).attr('alt') + "\" ?";
        } else {
            question = "Confirmez-vous la désactivation du lien Wikipédia pour le tag \"" + $(this).attr('alt') + "\" ?";
        }
        if(confirm(question)){
            validate_wp_link(this);
        }
        else{
            // Since the click event is dispatched after the checked changed, we change the checked changed if confirm is false.
            e.preventDefault(); // unvalidates user's click
            $(this).attr('checked', !new_checked);
        }
    });
    
    
    $.editable.addInputType('autocomplete', {
    	element : $.editable.types.text.element,
    	plugin : function(settings, original) {
    		$('input', this).autocomplete(settings.autocomplete);
    	}
    });
    
    $(".wikipediatag").editable(modify_tag_url, { 
    	indicator : "<img src='"+static_url+"hdabo/img/indicator.gif'>",
    	type      : "autocomplete",
    	tooltip   : "Cliquer pour éditer...",
    	onblur    : "submit",
    	submitdata: {csrfmiddlewaretoken:global_csrf_token, datasheet_id:$('#datasheet_id').val()},
    	callback  : function(value, settings) {
            $('#tag_table_container').html(value);
            init_tags_events();
    	},
    	autocomplete : {
			source: function( request, response ) {
				$.ajax({
					url: "http://fr.wikipedia.org/w/api.php",
					dataType: "jsonp",
					data: {
						action: "opensearch",
						limit: "20",
						namespace: "0",
						format: "json",
						search: request.term
					},
					success: function( data ) {
						response( $.map( data[1], function( item ) {
							return {
								label: item,
								value: item
							}
						}));
					}
				});
			},
			minLength: 2,
			open: function() {
				$( this ).removeClass( "ui-corner-all" ).addClass( "ui-corner-top" );
			},
			close: function() {
				$( this ).removeClass( "ui-corner-top" ).addClass( "ui-corner-all" );
			}    		
    	}
    });
}

function validate_wp_link(cb)
{
    var url = validate_wp_link_url;
    var id_tag = $(cb).attr('id');
    new_checked = $(cb).is(':checked');
    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token,
               datasheet_id:$('#datasheet_id').val(),
               tag_id:id_tag,
               activated:new_checked
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            $('#tag_table_container').html(msg);
            init_tags_events();
        }
    });
}

function remove_tag_from_list(btn)
{
    var url = remove_tag_from_list_url;
    var id_tag = $(btn).attr('id');
    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token,
               datasheet_id:$('#datasheet_id').val(),
               tag_id:id_tag
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            $('#tag_table_container').html(msg);
            init_tags_events();
        }
    });
}

function remove_tag_from_list(btn)
{
    var url = remove_tag_from_list_url;
    var id_tag = $(btn).attr('id');
    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token, 
               datasheet_id:$('#datasheet_id').val(),
               tag_id:id_tag
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            $('#tag_table_container').html(msg);
            init_tags_events();
        }
    });
}

function tag_up_down(arrow)
{
    if ($(arrow).is(".up")) {
        mv = "u";
    } else {
        mv = "d";
    }
    var url = tag_up_down_url;
    var id_tag = $(arrow).attr('id');
    // This indicates the position (from 0) of the tag in the list. NB : it is different from the TagSheet.order in the database.
    var pos_tag = $(arrow).attr('pos');
    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token, 
               datasheet_id:$('#datasheet_id').val(),
               tag_id:id_tag,
               move:mv,
               tag_pos:pos_tag
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            $('#tag_table_container').html(msg);
            init_tags_events();
        }
    });
}