# -*- coding: utf-8 -*-
from django.conf.urls import patterns, include, url
from django.views.generic import TemplateView
from renkanmanager.views import RenkanCopy, RenkanDelete
from hdalab.views.profile import ProfileHome, RenkanEdit, HdalabRenkanGetPut

# Uncomment the next two lines to enable the admin:
# from django.contrib import admin
# admin.autodiscover()

urlpatterns = patterns('',
    # Examples:
    # url(r'^$', 'hdalab.views.home', name='home'),
    # url(r'^hdalab/', include('hdalab.foo.urls')),

    # Uncomment the admin/doc line below to enable admin documentation:
    # url(r'^admin/doc/', include('django.contrib.admindocs.urls')),

    # Uncomment the next line to enable the admin:
    #url(r'^admin/', include(admin.site.urls)),
    
    url(r'^i18n/', include('django.conf.urls.i18n')),
    url('^jsi18n/?$', 'django.views.i18n.javascript_catalog', name='jsi18n.all'),
    url('^jsi18n/(?P<packages>\S+?)/$', 'django.views.i18n.javascript_catalog', {'domain':'djangojs'}, name='jsi18n'),
    
    url(r'^facettes/', TemplateView.as_view(template_name="facettes.html"), name='facettes'),
    url(r'^categories/', TemplateView.as_view(template_name="categories.html"), name='categories'),
    url(r'^thesaurus/', TemplateView.as_view(template_name="thesaurus.html"), name='thesaurus'),
    url(r'^$', TemplateView.as_view(template_name="index.html"), name='home'),
    
    url(r'^notice/(?P<hda_id>[\w-]+)$', 'hdalab.views.pages.datasheet', name='notice'),
    
    url(r'^renkan/edit/$', RenkanEdit.as_view(), name='renkan_edit'),
    url(r'^renkan/getput/$', HdalabRenkanGetPut.as_view(), name='renkan_get_put'),
    url(r'^renkan/view/$', TemplateView.as_view(template_name="renkan_view.html"), name='renkan_view'),
    url(r'^renkan/copy/(?P<rk_id>.*)$', RenkanCopy.as_view(), name='renkan_copy'),
    url(r'^renkan/delete/(?P<rk_id>.*)$', RenkanDelete.as_view(), name='renkan_delete'),
    url(r'^profile/$', ProfileHome.as_view(), name='profile_home'),

)

urlpatterns += patterns('hdalab.views.ajax',
    (r'^a/filter$', 'filter', {}, 'filter'),
    (r'^a/sessioninfo$', 'sessioninfo', {}, 'session_info'),
    (r'^a/tagsearch$', 'tagsearch', {}, 'tag_search'),
    (r'^a/catsearch$', 'catsearch', {}, 'cat_search'),
    (r'^a/cattree$', 'cattree', {}, 'cat_tree'),
    (r'^a/filltree$', 'filltree', {}, 'fill_tree'),
)
