'''
Created on May 30, 2011

@author: ymh
'''

from haystack import site
from haystack.indexes import SearchIndex, CharField
from hdabo.models import Datasheet

class DatasheetIndex(SearchIndex):
    '''
    The search index for the datasheet
    '''
    text = CharField(document=True, use_template=True)
    hda_id = CharField(model_attr='hda_id', indexed=True, stored=True)
    title = CharField(model_attr='title', indexed=True, stored=True, boost=2.0)
    description = CharField(model_attr='description', indexed=True, stored=True, boost=1.0)
    

site.register(Datasheet, DatasheetIndex)