# -*- coding: utf-8 -*-
'''
Created on May 25, 2011

@author: ymh
'''
from django.core.management.base import BaseCommand, CommandError
from hdabo.models import (Author, Datasheet, DocumentFormat, Domain, Organisation, 
    Tag, TagCategory, TaggedSheet, TimePeriod, Location)
import csv

class Command(BaseCommand):
    '''
    classdocs
    '''
    args = '<path_to_csv_file path_to_csv_file ...>'
    help = 'Import of a csv file for hdabo'
    
    def create_domain_period(self, row_value, klass, school_period):
        res_list = []
        if not row_value:
            return res_list
        for label_str in [dstr.strip() for dstr in row_value.decode("latin-1").split('\x0b')]:
            if label_str:
                res_obj, created = klass.objects.get_or_create(label=label_str, school_period=school_period, defaults={"label":label_str,"school_period":school_period}) #@UnusedVariable
                res_list.append(res_obj)
        return res_list

    def handle(self, *args, **options):
        for csv_path in args:
            with open(csv_path, 'rU') as csv_file: 
                reader = csv.DictReader(csv_file, delimiter=";")
    #Author Datasheet DocumentFormat Domain Organisation Tag TagCategory TaggedSheet TimePeriod
                
    #           ID;Titre;Url;Desc;Tag;Org;Org_Home;Domaine;Periode1;Periode2;Periode3;Theme2;Theme3;Sousdom;Ville;Insee;Format;Auteur;Datcre;Datmaj;Comment
                for row in reader:
                    # start transaction
                    if row[u'Autheur']:
                        author_array = row[u'Autheur'].split(" ")
                        author, created = Author.objects.get_or_create(hda_id=row[u'Autheur'], defaults={"firstname":author_array[0], "lastname":author_array[1]})
                    else:
                        author = None
                        
                    if row[u"Org"]:
                        org, created = Organisation.objects.get_or_create(hda_id=row[u'Org'], defaults={"name":row[u'Org'], "website" : row[u'Org_Home']})
                    else:
                        org = None
                        
                    if row[u"Ville"]:
                        loc, created = Location.objects.get_or_create(insee=row[u'Insee'], defaults={"name": row[u'Ville'], "insee": row[u'Insee']})
                    else:
                        loc = None
                        
                    if row[u"Format"]:
                        format, created = DocumentFormat.objects.get_or_create(label=row[u'Format'], defaults={"label": row[u"Format"]})                    
                    else:
                        format = None
                    
                    domains = self.create_domain_period(row[u"Domaine"], Domain, Domain.DOMAIN_PERIOD_DICT[u'Global'])
                                                    
                    primary_periods = self.create_domain_period(row[u"Periode1"], TimePeriod, TimePeriod.TIME_PERIOD_DICT[u'Primaire'])
                    college_periods = self.create_domain_period(row[u"Periode2"], TimePeriod, TimePeriod.TIME_PERIOD_DICT[u'Collège'])
                    highschool_periods = self.create_domain_period(row[u"Periode3"], TimePeriod, TimePeriod.TIME_PERIOD_DICT[u'Lycée'])
                                
                    primary_themes = self.create_domain_period(row[u"Sousdom"], Domain, Domain.DOMAIN_PERIOD_DICT[u'Primaire'])
                    college_themes = self.create_domain_period(row[u"Theme2"], Domain, Domain.DOMAIN_PERIOD_DICT[u'Collège'])
                    highschool_themes = self.create_domain_period(row[u"Theme3"], Domain, Domain.DOMAIN_PERIOD_DICT[u'Lycée'])
                    
                    
                    
                    tags = []
                    if row[u'Tag']:
                        for tag in [t.strip().lower() for t in row[u'Tag'].split(u";")]:
                            tag_obj, created = Tag.objects.get_or_create(label=tag, defaults={"label":tag, "original_label":tag})
                         
                        
                    
                
                #commit transaction