function showData(_label, _data) {
    $(".disciplist li").each(function() {
        if ($(this).text().trim().toLowerCase() === _label.toLowerCase()) {
            $(this).addClass("selected");
        }
    })
    $(".label-name").html(_label);
    if (_data) {
        renderData($("#tree"), _data, 1);
        $(".results").show();
        $(".content-count").html($(".cattree a.content").length);
        $(".category-count").html(Math.max(0, $("li.themeli").length - 1));
    }
    else {
        $("#tree").html("");
        $(".results").hide();
    }
}

function gettree(_label) {
    $(".disciplist li").removeClass("selected");
    $("#tree").html('<div class="loading"></div>');
    $.getJSON(endpoints.cat_tree, {
        label : _label
    }, function(_data) {
        showData(_label, _data);
    });
}

$(function() {
    $("#catsearch").autocomplete({
        source : endpoints.cat_search,
        minLength : 2,
        select : function(event, ui) {
            gettree(ui.item.value);
        }
    }).data("ui-autocomplete")._renderItem = function(ul, item) {
        return $("<li></li>").data("item.autocomplete", item).append(
                "<a>"
                        + item.label.replace(new RegExp('('
                                + $("#catsearch").val()
                                        .replace(/(\W)/g, '\\$1') + ')', 'gi'),
                                '<strong>$1</strong>') + "</a>").appendTo(ul)
    };
    $("#catform").submit(function() {
        gettree($("#catsearch").val());
    });
    gettree("cinéma");
    $(".disciplist li").click(function() {
        gettree($(this).text().trim());
        $("#catsearch").val("");
    });
    $("#morecategories").click(function() {
        if ($(".disciplist").hasClass('extend')) {
            $(".disciplist").removeClass('extend');
            $("#morecategories").removeClass('less');
        }
        else {
            $(".disciplist").addClass('extend');
            $("#morecategories").addClass('less');
        }
    });
});
