'''
Created on Jul 17, 2014

@author: tc
'''
from django.conf import settings
from django.db import models
from hdabo.models import User
from easy_thumbnails.fields import ThumbnailerImageField


class Renkan(models.Model):
    
    EDITION = 1
    PUBLISHED = 2
    MODERATED = 3
    REJECTED = 4
      
    STATE_CHOICES = (
    (EDITION, 'edition'),
    (PUBLISHED, 'published'),
    (MODERATED, 'moderated'),
    (REJECTED, 'rejected'),
    )
    
    owner = models.ForeignKey(User, blank=False, null=False)
    rk_id = models.CharField(max_length=1024, unique=True, blank=False, null=False) # typically UUID
    content = models.TextField(blank=True, null=True)
    title = models.CharField(max_length=1024, null=True)
    state = models.IntegerField(choices=STATE_CHOICES, default=1)
    image = ThumbnailerImageField(upload_to="thumbnails/renkan/", default=settings.DEFAULT_RENKAN_ICON)
    creation_date = models.DateTimeField(auto_now_add=True)
    modification_date = models.DateTimeField(auto_now=True)
    
    class Meta:
        app_label = 'hdalab'
