# -*- coding: utf-8 -*-
'''
Created on Jan 27, 2012

@author: ymh
'''
from django.db import models
from hdabo.models import Tag, Datasheet


class TagYears(models.Model):
    
    tag = models.ForeignKey(Tag, related_name="years", blank=False, null=False, db_index=True)
    start_year = models.IntegerField(blank=False, null=False, db_index=True)
    end_year = models.IntegerField(blank=False, null=False, db_index=True)
    
    class Meta:
        app_label = 'hdalab'
        

class TagLinks(models.Model):
    
    subject = models.ForeignKey(Tag, blank=False, null=False, db_index=True, related_name="taglinks_subjects")
    object = models.ForeignKey(Tag, blank=False, null=False, db_index=True, related_name="taglinks_objects")
    
    class Meta:
        app_label = 'hdalab'

class Country(models.Model):
    
    dbpedia_uri = models.URLField(verify_exists=False, max_length=255, blank=False, null=False, db_index=True, unique=True)
    
    class Meta:
        app_label = 'hdalab'

class GeoInclusion(models.Model):
    
    tag = models.OneToOneField(Tag, related_name="locatedin", db_index=True)
    country = models.ForeignKey(Country, blank=False, null=False, related_name="includes", db_index=True)
    
    class Meta:
        app_label = 'hdalab'

class DbpediaFields(models.Model):

    dbpedia_uri = models.URLField(verify_exists=False, max_length=2048, blank=False, null=False, db_index=True, unique=False)
    tag = models.OneToOneField(Tag, blank=True, null=True, db_index=True, related_name="dbpedia_fields")
    abstract = models.TextField(blank=True, null=True)
    thumbnail = models.URLField(verify_exists=False, max_length=2048, blank=True, null=True, db_index=False)    
    label = models.CharField(max_length=2048, unique=False, blank=True, null=True)

    class Meta:
        app_label = 'hdalab'


class DbpediaFieldsTranslation(models.Model):

    master = models.ForeignKey(DbpediaFields, blank=False, null=False, db_index=True, related_name="translations")
    language_code = models.CharField(max_length=15, blank=False, null=False, db_index=True)
    label = models.CharField(max_length=2048, unique=False, blank=True, null=False)
    abstract = models.TextField(blank=True, null=True)
    is_label_translated = models.BooleanField(default=True)
    is_abstract_translated = models.BooleanField(default=True)
    class Meta:
        app_label = 'hdalab'
        unique_together = ('master', 'language_code')


class HdaSession(models.Model):
    
    sessionid = models.CharField(max_length=36, unique=True, blank=False, null=False, db_index=True)
    data = models.TextField(blank=True, null=True)
    
    class Meta:
        app_label = 'hdalab'

class InseeCoords(models.Model):
    
    insee = models.IntegerField(primary_key=True)
    city_name = models.CharField(max_length=255, blank=False, null=False)
    latitude = models.FloatField(blank=False, null=False)
    longitude = models.FloatField(blank=False, null=False)
    
    class Meta:
        app_label = 'hdalab'

class DatasheetExtras(models.Model):
    
    datasheet = models.OneToOneField(Datasheet, related_name="extras", db_index=True)
    insee = models.ForeignKey(InseeCoords, blank=True, null=True, db_index=True)
    
    class Meta:
        app_label = 'hdalab'