# -*- coding: utf-8 -*-
'''
Created on Jan 29, 2012

@author: ymh
'''
from django.conf import settings
from django.core.management.base import NoArgsCommand
from django.core.management.color import no_style
from hdabo.utils import show_progress
import re
from hdabo.models import Tag
from hdalab.models import TagYears

class Command(NoArgsCommand):
    def handle_noargs(self, **options):
        self.style = no_style()

        qs = Tag.objects.filter(category__label="Datation")
        total = qs.count()
        dbptstart = len(settings.DBPEDIA_URI_TEMPLATE % ("resource",""))
        #dbptstart = len("http://dbpedia.org/resource/")
        
        writer = None
        
        for i,tag in enumerate(qs):
            #writer = show_progress(i+1, total, tag.label, 50, writer)
            start = None
            end = None
            range = re.findall("^(Années )?(-?\d+)\-?(\d+)?( en France| au cinéma)?$", tag.label)
            print "0 " + tag.label.encode("utf8") + ", " + tag.dbpedia_uri.encode("utf8")
            # S'il s'agit d'une année ou d'un ensemble d'années
            if range:
                start = int(range[0][1])
                end = start
                if range[0][0]:
                    end = start + 10
                if range[0][2]:
                    end = int(range[0][2])
                print "1 start " + str(start) + ", end" + str(end)
            else:
                if tag.dbpedia_uri:
                    dbptitle = tag.dbpedia_uri[dbptstart:]
                    # S'il s'agit d'un siècle, on se fie à l'URL DBpedia,
                    # car les siècles y sont en chiffres arabes. Exemple = XIIIe_siècle
                    century = re.findall("(\d+)(e|ème)_siècle_?(av._J.-C.)?", dbptitle)
                    if century:
                        val = int(century[0][0])
                        if century[0][2] == 'av._J.-C.':
                            start = -100*val
                        else:
                            start = 1 + 100*(val-1)
                        end = start + 100
                        print "2 start " + str(start) + ", end" + str(end)
            
            if start != None and end != None:
                ty = TagYears.objects.create(tag=tag, start_year=start, end_year=end)
                ty.save()
