/* Rkns.HdaNotices bin definition : search form and result rendering */

Rkns.HdaNotices = {
};

Rkns.HdaNotices.Search = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.lang = _opts.lang || "fr";
    this.image = _opts.image;
    this.url = _opts.url;
};

Rkns.HdaNotices.Search.prototype.getBgClass = function() {
    return "Rk-HdaNotices-Search-Icon";
};

Rkns.HdaNotices.Search.prototype.getSearchTitle = function() {
    return this.renkan.translate("Notices Hda");
};

Rkns.HdaNotices.Search.prototype.search = function(_q) {
    this.renkan.tabs.push(
        new Rkns.HdaNotices.Bin(this.renkan, {
            lang: this.lang,
            url: this.url,
            image: this.image,
            search: _q
        })
    );
};

Rkns.HdaNotices.Bin = Rkns.Utils.inherit(Rkns._BaseBin);

Rkns.HdaNotices.Bin.prototype.resultTemplate = Rkns._.template(
    '<li class="Rk-Wikipedia-Result Rk-Bin-Item" draggable="true" data-uri="<%-url%>" ' +
    'data-title="<%-title%>" data-description="<%-full_description%>" data-image="<%-image%>">' +
    '<img class="Rk-Wikipedia-Icon" src="<%-image%>"></div><h4 class="Rk-Wikipedia-Title"><a href="<%-url%>" target="_blank"><%=htitle%></a></h4>' +
    '<p class="Rk-Wikipedia-Snippet"><%=hdescription%></p></li>'
);

Rkns.HdaNotices.Bin.prototype._init = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.search = _opts.search;
    this.lang = _opts.lang || "fr";
    this.url = _opts.url;
    this.image = _opts.image;
    this.title_icon_$.addClass('Rk-HdaNotices-Title-Icon');
    this.title_$.html(this.search).addClass("Rk-HdaNotices-Title");
    this.refresh();
};

Rkns.HdaNotices.Bin.prototype.render = function(searchbase) {
    var search = searchbase || Rkns.Utils.regexpFromTextOrArray();
    var highlightrx = (search.isempty ? Rkns.Utils.regexpFromTextOrArray(this.search) : search);
    function highlight(_text) {
        return highlightrx.replace(_(_text).escape(), "<span class='searchmatch'>$1</span>");
    }
    var _html = "",
        _this = this,
        count = 0;
    Rkns._(this.data.results).each(function(_result) {
        console.log(_result);
        var title = _result.title,
            url = _result.url,
            full_description = _result.description,
            description = _result.description.substr(0, _result.description.indexOf(" ", 170)) + "...",
            image = "http://www.histoiredesarts.culture.fr/images/pf/" + _result.hda_id + ".jpg";
        if (!search.isempty && !search.test(title) && !search.test(description)) {
            return;
        }
        count++;
        _html += _this.resultTemplate({
            url: url,
            title: title,
            htitle: highlight(title),
            full_description: full_description,
            description: description,
            hdescription: highlight(description),
            image: image
        });
    });
    _this.main_$.html(_html);
    if (!search.isempty && count) {
        this.count_$.text(count).show();
    } else {
        this.count_$.hide();
    }
    if (!search.isempty && !count) {
        this.$.hide();
    } else {
        this.$.show();
    }
    this.renkan.resizeBins();
};

Rkns.HdaNotices.Bin.prototype.refresh = function() {
    var _this = this;
    console.log("refresh");
    Rkns.$.ajax({
        url: this.url + "?q=" + encodeURIComponent(this.search) + "&format=json&limit=50",
        success: function(_data) {
            console.log("ntm");
            _this.data = _data;
            _this.render();
        }
    });
};


/* Rkns.HdaTags bin definition : search form and result rendering */
/*
Rkns.HdaTags = {
};

Rkns.HdaTags.Search = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.lang = _opts.lang || "fr";
    this.image = _opts.image;
    console.log("2",this.image);
};

Rkns.HdaTags.Search.prototype.getBgClass = function() {
    return "Rk-HdaTags-Search-Icon";
};

Rkns.HdaTags.Search.prototype.getSearchTitle = function() {
    return this.renkan.translate("Tags Hda");
};

Rkns.HdaTags.Search.prototype.search = function(_q) {
    this.renkan.tabs.push(
        new Rkns.HdaTags.Bin(this.renkan, {
            lang: this.lang,
            image: this.image,
            search: _q
        })
    );
};

Rkns.HdaTags.Bin = Rkns.Utils.inherit(Rkns._BaseBin);

Rkns.HdaTags.Bin.prototype.resultTemplate = Rkns._.template(
    '<li class="Rk-Wikipedia-Result Rk-Bin-Item" draggable="true" data-uri="<%-url%>" ' +
    'data-title="Wikipedia: <%-title%>" data-description="<%-description%>" data-image="<%- Rkns.Utils.getFullURL( static_url + \'img/wikipedia.png\' ) %>">' +
    '<img class="Rk-Wikipedia-Icon" src="<%-image%>"></div><h4 class="Rk-Wikipedia-Title">HDA TAGS : <a href="<%-url%>" target="_blank"><%=htitle%></a></h4>' +
    '<p class="Rk-Wikipedia-Snippet"><%=hdescription%></p></li>'
);

Rkns.HdaTags.Bin.prototype._init = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.search = _opts.search;
    this.lang = _opts.lang || "fr";
    this.image = _opts.image;
    console.log("1",this.image,_opts);
    this.title_icon_$.addClass('Rk-Wikipedia-Title-Icon');
    this.title_$.html(this.search).addClass("Rk-Wikipedia-Title");
    this.refresh();
};

Rkns.HdaTags.Bin.prototype.render = function(searchbase) {
    var search = searchbase || Rkns.Utils.regexpFromTextOrArray();
    var highlightrx = (search.isempty ? Rkns.Utils.regexpFromTextOrArray(this.search) : search);
    function highlight(_text) {
        return highlightrx.replace(_(_text).escape(), "<span class='searchmatch'>$1</span>");
    }
    var _html = "",
        _this = this,
        count = 0;
    Rkns._(this.data.query.search).each(function(_result) {
        var title = _result.title,
            url = "http://" + _this.lang + ".wikipedia.org/wiki/" + encodeURI(title.replace(/ /g,"_")),
            description = Rkns.$('<div>').html(_result.snippet).text();
        if (!search.isempty && !search.test(title) && !search.test(description)) {
            return;
        }
        count++;
        _html += _this.resultTemplate({
            url: url,
            title: title,
            htitle: highlight(title),
            description: description,
            hdescription: highlight(description),
            static_url: _this.renkan.options.static_url,
            image: _this.image
        });
    });
    _this.main_$.html(_html);
    if (!search.isempty && count) {
        this.count_$.text(count).show();
    } else {
        this.count_$.hide();
    }
    if (!search.isempty && !count) {
        this.$.hide();
    } else {
        this.$.show();
    }
    this.renkan.resizeBins();
};

Rkns.HdaTags.Bin.prototype.refresh = function() {
    var _this = this;
    Rkns.$.ajax({
        url: "http://" + _this.lang + ".wikipedia.org/w/api.php?action=query&list=search&srsearch=" + encodeURIComponent(this.search) + "&format=json",
        dataType: "jsonp",
        success: function(_data) {
            _this.data = _data;
            _this.render();
        }
    });
};
*/