'''
Created on Jul 17, 2014

@author: tc
'''
from renkanmanager.models import Renkan

from django.conf import settings
from django.db import models
from django.utils.translation import ugettext as _


class HdalabRenkan(models.Model):
    
    EDITION = 1
    MODERATED = 2
    PUBLISHED = 3
    REJECTED = 4
      
    STATE_CHOICES = (
    (EDITION, 'edition'),
    (MODERATED, 'moderated'),
    (PUBLISHED, 'published'),
    (REJECTED, 'rejected'),
    )
    
    STATE_CHOICES_DICT = {
        EDITION: _('edition_state'),
        MODERATED: _('moderated_state'),
        PUBLISHED: _('published_state'),
        REJECTED: _('rejected_state')
    }
    
    renkan = models.ForeignKey(Renkan, blank=False, null=False)
    state = models.IntegerField(choices=STATE_CHOICES, default=1)
    
    class Meta:
        app_label = 'hdalab'


class HdalabRenkanStateTransition(models.Model):

    renkan = models.ForeignKey(HdalabRenkan, blank=False, null=False)
    from_state = models.IntegerField(choices=HdalabRenkan.STATE_CHOICES, default=1, blank=False, null=False)
    to_state = models.IntegerField(choices=HdalabRenkan.STATE_CHOICES, default=1, blank=False, null=False)
    ts = models.DateTimeField(auto_now_add=True, blank=False, null=False)
    message = models.TextField(blank=True, null=True)
    author = models.ForeignKey(settings.AUTH_USER_MODEL, blank=False, null=False)
    
    class Meta:
        app_label = 'hdalab'
